/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.tasks;

import com.sun.faces.config.manager.FacesConfigInfo;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.InjectionProvider;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProvideMetadataToAnnotationScanTask {
    private static final Pattern FACES_CONFIG_XML_IN_JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*(/faces-config.xml|/*.\\.faces-config.xml)");
    private static final Pattern CURRENT_RESOURCE_IN_JAR_PATTERN = Pattern.compile("(?<=\\.jar)[!/].*");
    private final DocumentInfo[] documentInfos;
    private final InjectionProvider containerConnector;
    private Set<URI> uris;
    private Set<String> jarNames;

    public ProvideMetadataToAnnotationScanTask(DocumentInfo[] documentInfos, InjectionProvider containerConnector) {
        this.documentInfos = documentInfos;
        this.containerConnector = containerConnector;
    }

    private void initializeIvars(Set<Class<?>> annotatedSet) {
        if (this.uris != null || this.jarNames != null) {
            return;
        }
        this.uris = new HashSet<URI>(this.documentInfos.length);
        this.jarNames = new HashSet<String>(this.documentInfos.length);
        for (DocumentInfo docInfo : this.documentInfos) {
            String jarName;
            URI facesConfigURI = docInfo.getSourceURI();
            Matcher jarMatcher = FACES_CONFIG_XML_IN_JAR_PATTERN.matcher(facesConfigURI == null ? "" : facesConfigURI.toString());
            if (!jarMatcher.matches() || this.jarNames.contains(jarName = jarMatcher.group(2))) continue;
            FacesConfigInfo configInfo = new FacesConfigInfo(docInfo);
            if (!configInfo.isMetadataComplete()) {
                this.uris.add(facesConfigURI);
                this.jarNames.add(jarName);
                continue;
            }
            ArrayList toRemove = new ArrayList(1);
            String facesConfigURIString = facesConfigURI.toString();
            if (annotatedSet == null) continue;
            for (Class clazz : annotatedSet) {
                URL classURI = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class");
                String jarURIString = CURRENT_RESOURCE_IN_JAR_PATTERN.split(classURI.toString(), 2)[0];
                if (!facesConfigURIString.startsWith(jarURIString)) continue;
                toRemove.add(clazz);
            }
            annotatedSet.removeAll(toRemove);
        }
    }

    public Set<URI> getAnnotationScanURIs(Set<Class<?>> annotatedSet) {
        this.initializeIvars(annotatedSet);
        return this.uris;
    }

    public Set<String> getJarNames(Set<Class<?>> annotatedSet) {
        this.initializeIvars(annotatedSet);
        return this.jarNames;
    }

    public AnnotationScanner getAnnotationScanner() {
        if (this.containerConnector instanceof AnnotationScanner) {
            return (AnnotationScanner)((Object)this.containerConnector);
        }
        return null;
    }
}

