/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;
import org.apache.tinkerpop.gremlin.util.GremlinValueComparator;

public enum Compare implements PBiPredicate<Object, Object>
{
    eq{

        @Override
        public boolean test(Object first, Object second) {
            return GremlinValueComparator.COMPARABILITY.equals(first, second);
        }
    }
    ,
    neq{

        @Override
        public boolean test(Object first, Object second) {
            return !eq.test(first, second);
        }
    }
    ,
    gt{

        @Override
        public boolean test(Object first, Object second) {
            if (!GremlinValueComparator.comparable(first, second)) {
                return false;
            }
            return GremlinValueComparator.COMPARABILITY.compare(first, second) > 0;
        }
    }
    ,
    gte{

        @Override
        public boolean test(Object first, Object second) {
            if (!GremlinValueComparator.comparable(first, second)) {
                return false;
            }
            return GremlinValueComparator.COMPARABILITY.compare(first, second) >= 0;
        }
    }
    ,
    lt{

        @Override
        public boolean test(Object first, Object second) {
            if (!GremlinValueComparator.comparable(first, second)) {
                return false;
            }
            return GremlinValueComparator.COMPARABILITY.compare(first, second) < 0;
        }
    }
    ,
    lte{

        @Override
        public boolean test(Object first, Object second) {
            if (!GremlinValueComparator.comparable(first, second)) {
                return false;
            }
            return GremlinValueComparator.COMPARABILITY.compare(first, second) <= 0;
        }
    };

}

