"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.choose = exports.count = exports.sum = exports.neq = exports.eq = exports.spaces = exports.pipe = exports.last = void 0;
var last = function (array) { return array.slice(-1)[0]; };
exports.last = last;
var pipe = function () {
    var fns = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        fns[_i] = arguments[_i];
    }
    return function (value) { return fns.reduce(function (value, fn) { return fn(value); }, value); };
};
exports.pipe = pipe;
var spaces = function (numberOfSpaces) { return Array(numberOfSpaces + 1).join(' '); };
exports.spaces = spaces;
var eq = function (a) { return function (b) { return a === b; }; };
exports.eq = eq;
var neq = function (a) { return function (b) { return a !== b; }; };
exports.neq = neq;
var sum = function (a, b) { return a + b; };
exports.sum = sum;
var count = function (array) { var _a; return (_a = array === null || array === void 0 ? void 0 : array.length) !== null && _a !== void 0 ? _a : 0; };
exports.count = count;
var choose = function (getCondition, getThen, getElse) { return function () {
    var params = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        params[_i] = arguments[_i];
    }
    return getCondition.apply(void 0, params) ? getThen.apply(void 0, params) : getElse.apply(void 0, params);
}; };
exports.choose = choose;
