/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.ticket.EncodedTicket;
import org.apereo.cas.ticket.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public interface TicketCompactor<T extends Ticket> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TicketCompactor.class);
    public static final String DELIMITER = ",";

    public Ticket expand(String var1) throws Throwable;

    default public String compact(Ticket ticket) throws Exception {
        long creationTime = ticket.getCreationTime().toEpochSecond();
        long expirationTime = ticket.getExpirationPolicy().toMaximumExpirationTime(ticket).toEpochSecond();
        StringBuilder builder = new StringBuilder(String.format("%s%s%s", creationTime, DELIMITER, expirationTime));
        return this.compact(builder, ticket);
    }

    default public String compact(StringBuilder compactBuilder, Ticket ticket) throws Exception {
        return compactBuilder.toString();
    }

    public Class<T> getTicketType();

    default public long getMaximumTicketLength() {
        return 0L;
    }

    default public CompactTicket parse(String ticketId) {
        List<String> ticketElements = List.of(StringUtils.commaDelimitedListToStringArray((String)ticketId));
        Instant creationTimeInSeconds = Instant.ofEpochSecond(Long.parseLong(ticketElements.get(CompactTicketIndexes.CREATION_TIME.getIndex())));
        Instant expirationTimeInSeconds = Instant.ofEpochSecond(Long.parseLong(ticketElements.get(CompactTicketIndexes.EXPIRATION_TIME.getIndex())));
        return new CompactTicket(ticketElements, creationTimeInSeconds, expirationTimeInSeconds);
    }

    default public Ticket validate(EncodedTicket finalTicket) {
        if (this.getMaximumTicketLength() > 0L && (long)finalTicket.getId().length() >= this.getMaximumTicketLength()) {
            LOGGER.warn("Final ticket id [{}] length [{}] exceeds [{}] characters", new Object[]{finalTicket.getId(), finalTicket.getId().length(), this.getMaximumTicketLength()});
        }
        return finalTicket;
    }

    public static enum CompactTicketIndexes {
        CREATION_TIME(0),
        EXPIRATION_TIME(1),
        SERVICE(2);

        private final int index;

        @Generated
        private CompactTicketIndexes(int index) {
            this.index = index;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }
    }

    public record CompactTicket(List<String> ticketElements, Instant creationTime, Instant expirationTime) {
    }
}

