/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.persistence.entity;

import java.io.Serializable;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntityManager;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class ResourceRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private EventResourceEntity entity;
    protected boolean deleted;

    public ResourceRef() {
    }

    public ResourceRef(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        this.ensureInitialized();
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public void setValue(String name, byte[] bytes) {
        this.name = name;
        this.setBytes(bytes);
    }

    private void setBytes(byte[] bytes) {
        EventResourceEntityManager resourceEntityManager = CommandContextUtil.getResourceEntityManager();
        if (this.id == null) {
            if (bytes != null) {
                this.entity = (EventResourceEntity)resourceEntityManager.create();
                this.entity.setName(this.name);
                this.entity.setBytes(bytes);
                resourceEntityManager.insert(this.entity);
                this.id = this.entity.getId();
            }
        } else {
            this.ensureInitialized();
            this.entity.setBytes(bytes);
            resourceEntityManager.update(this.entity);
        }
    }

    public EventResourceEntity getEntity() {
        this.ensureInitialized();
        return this.entity;
    }

    public void delete() {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                CommandContextUtil.getResourceEntityManager().delete(this.entity);
            } else {
                CommandContextUtil.getResourceEntityManager().delete(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    private void ensureInitialized() {
        if (this.id != null && this.entity == null) {
            this.entity = (EventResourceEntity)CommandContextUtil.getResourceEntityManager().findById(this.id);
            this.name = this.entity.getName();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String toString() {
        return "ResourceRef[id=" + this.id + ", name=" + this.name + ", entity=" + String.valueOf(this.entity) + (this.deleted ? ", deleted]" : "]");
    }
}

