/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class TriggerExecutionOperation
extends AbstractOperation {
    protected boolean triggerAsync;

    public TriggerExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    public TriggerExecutionOperation(CommandContext commandContext, ExecutionEntity execution, boolean triggerAsync) {
        super(commandContext, execution);
        this.triggerAsync = triggerAsync;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof FlowNode) {
            ActivityBehavior activityBehavior = (ActivityBehavior)((FlowNode)currentFlowElement).getBehavior();
            if (!(activityBehavior instanceof TriggerableActivityBehavior)) throw new FlowableException("Cannot trigger " + String.valueOf(this.execution) + " : the activityBehavior " + String.valueOf(activityBehavior.getClass()) + " does not implement the " + TriggerableActivityBehavior.class.getName() + " interface");
            if (!this.triggerAsync) {
                ((TriggerableActivityBehavior)activityBehavior).trigger(this.execution, null, null);
                return;
            } else {
                ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
                JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity job = JobUtil.createJob(this.execution, (BaseElement)currentFlowElement, "async-trigger", processEngineConfiguration);
                jobService.createAsyncJob(job, true);
                jobService.scheduleAsyncJob(job);
            }
            return;
        } else {
            if (currentFlowElement != null) throw new FlowableException("Programmatic error: cannot trigger " + String.valueOf(this.execution) + ", invalid flow element type found: " + currentFlowElement.getClass().getName() + ".");
            throw new FlowableException("Cannot trigger " + String.valueOf(this.execution) + " : no current flow element found. Check the execution id that is being passed (it should not be a process instance execution, but a child execution currently referencing a flow element).");
        }
    }
}

