/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventsubscription.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.UUID;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.EventSubscriptionServiceImpl;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntityManagerImpl;
import org.flowable.eventsubscription.service.impl.persistence.entity.data.EventSubscriptionDataManager;
import org.flowable.eventsubscription.service.impl.persistence.entity.data.impl.MybatisEventSubscriptionDataManager;

public class EventSubscriptionServiceConfiguration
extends AbstractServiceConfiguration<EventSubscriptionServiceConfiguration> {
    protected EventSubscriptionService eventSubscriptionService = new EventSubscriptionServiceImpl(this);
    protected EventSubscriptionDataManager eventSubscriptionDataManager;
    protected EventSubscriptionEntityManager eventSubscriptionEntityManager;
    private Duration eventSubscriptionLockTime = Duration.ofMinutes(10L);
    private String lockOwner = UUID.randomUUID().toString();
    protected ObjectMapper objectMapper;

    public EventSubscriptionServiceConfiguration(String engineName) {
        super(engineName);
    }

    protected EventSubscriptionServiceConfiguration getService() {
        return this;
    }

    public void init() {
        this.configuratorsBeforeInit();
        this.initDataManagers();
        this.initEntityManagers();
        this.configuratorsAfterInit();
    }

    public void initDataManagers() {
        if (this.eventSubscriptionDataManager == null) {
            this.eventSubscriptionDataManager = new MybatisEventSubscriptionDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.eventSubscriptionEntityManager == null) {
            this.eventSubscriptionEntityManager = new EventSubscriptionEntityManagerImpl(this, this.eventSubscriptionDataManager);
        }
    }

    public EventSubscriptionServiceConfiguration getIdentityLinkServiceConfiguration() {
        return this;
    }

    public EventSubscriptionService getEventSubscriptionService() {
        return this.eventSubscriptionService;
    }

    public EventSubscriptionServiceConfiguration setEventSubscriptionService(EventSubscriptionService eventSubscriptionService) {
        this.eventSubscriptionService = eventSubscriptionService;
        return this;
    }

    public EventSubscriptionDataManager getEventSubscriptionDataManager() {
        return this.eventSubscriptionDataManager;
    }

    public EventSubscriptionServiceConfiguration setEventSubscriptionDataManager(EventSubscriptionDataManager eventSubscriptionDataManager) {
        this.eventSubscriptionDataManager = eventSubscriptionDataManager;
        return this;
    }

    public EventSubscriptionEntityManager getEventSubscriptionEntityManager() {
        return this.eventSubscriptionEntityManager;
    }

    public EventSubscriptionServiceConfiguration setEventSubscriptionEntityManager(EventSubscriptionEntityManager eventSubscriptionEntityManager) {
        this.eventSubscriptionEntityManager = eventSubscriptionEntityManager;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public EventSubscriptionServiceConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public Duration getEventSubscriptionLockTime() {
        return this.eventSubscriptionLockTime;
    }

    public EventSubscriptionServiceConfiguration setEventSubscriptionLockTime(Duration eventSubscriptionLockTime) {
        this.eventSubscriptionLockTime = eventSubscriptionLockTime;
        return this;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public EventSubscriptionServiceConfiguration setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
        return this;
    }
}

