/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.Encryptor;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.spring.security.DefaultEncryptor;
import org.apache.syncope.core.spring.security.SecurityProperties;

public class DefaultEncryptorManager
implements EncryptorManager {
    protected final SecurityProperties securityProperties;
    protected final Map<String, DefaultEncryptor> instances = new ConcurrentHashMap<String, DefaultEncryptor>();

    public DefaultEncryptorManager(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public Encryptor getInstance() {
        return this.getInstance(null);
    }

    public Encryptor getInstance(String aesSecretKey) {
        String actualKey = StringUtils.isBlank((CharSequence)aesSecretKey) ? this.securityProperties.getAesSecretKey() : aesSecretKey;
        return this.instances.computeIfAbsent(actualKey, k -> new DefaultEncryptor((String)k, this.securityProperties.getDigester()));
    }
}

