/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.client.authz;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderAuthorizer;
import org.pac4j.core.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseDelegatedClientIdentityProviderAuthorizer
implements DelegatedClientIdentityProviderAuthorizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatedClientIdentityProviderAuthorizer.class);
    private final ServicesManager servicesManager;
    private final AuditableExecution delegatedAuthenticationPolicyEnforcer;
    private final TenantExtractor tenantExtractor;

    public boolean isDelegatedClientAuthorizedFor(String clientName, Service service, RequestContext context) throws Throwable {
        Optional tenantDefinition = this.tenantExtractor.extract(context);
        return (tenantDefinition.isEmpty() || this.isDelegatedClientAuthorizedForTenant(clientName, (TenantDefinition)tenantDefinition.get())) && this.handleAuthorizationForService(clientName, service);
    }

    public boolean isDelegatedClientAuthorizedFor(String clientName, Service service, HttpServletRequest request) throws Throwable {
        Optional tenantDefinition = this.tenantExtractor.extract(request);
        return (tenantDefinition.isEmpty() || this.isDelegatedClientAuthorizedForTenant(clientName, (TenantDefinition)tenantDefinition.get())) && this.handleAuthorizationForService(clientName, service);
    }

    protected boolean handleAuthorizationForService(String clientName, Service service) throws Throwable {
        if (service == null || StringUtils.isBlank((CharSequence)service.getId())) {
            LOGGER.debug("Can not evaluate delegated authentication policy without a service");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)clientName)) {
            LOGGER.debug("No identity provider is provided to enforce authorization for delegated authentication. SSO session may have been established without delegated authentication");
            return true;
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed(registeredService, service)) {
            LOGGER.warn("Service access for [{}] is denied", (Object)registeredService);
            return false;
        }
        LOGGER.trace("Located registered service definition [{}] matching [{}]", (Object)registeredService, (Object)service);
        AuditableContext auditContext = AuditableContext.builder().registeredService(registeredService).service(service).properties(CollectionUtils.wrap((String)Client.class.getSimpleName(), (Object)clientName)).build();
        AuditableExecutionResult result = this.delegatedAuthenticationPolicyEnforcer.execute(auditContext);
        if (!result.isExecutionFailure()) {
            LOGGER.debug("Delegated authentication policy for [{}] allows for using provider [{}]", (Object)registeredService, (Object)clientName);
            return true;
        }
        LOGGER.warn("Delegated authentication policy for [{}] refuses access to provider [{}]", (Object)registeredService.getServiceId(), (Object)clientName);
        return false;
    }

    protected boolean isDelegatedClientAuthorizedForTenant(String clientName, TenantDefinition tenantDefinition) {
        List allowedProviders = tenantDefinition.getDelegatedAuthenticationPolicy().getAllowedProviders();
        boolean allowedByTenant = StringUtils.isBlank((CharSequence)clientName) || allowedProviders == null || allowedProviders.isEmpty() || allowedProviders.contains(clientName);
        LOGGER.debug("Tenant [{}] allows for delegated authentication with provider [{}]: [{}]", new Object[]{tenantDefinition.getId(), clientName, BooleanUtils.toStringYesNo((boolean)allowedByTenant)});
        return allowedByTenant;
    }

    @Generated
    public BaseDelegatedClientIdentityProviderAuthorizer(ServicesManager servicesManager, AuditableExecution delegatedAuthenticationPolicyEnforcer, TenantExtractor tenantExtractor) {
        this.servicesManager = servicesManager;
        this.delegatedAuthenticationPolicyEnforcer = delegatedAuthenticationPolicyEnforcer;
        this.tenantExtractor = tenantExtractor;
    }
}

