/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.web.servlet.View;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.mvc.builder.MvcViewFactoryCreator;
import org.springframework.webflow.mvc.servlet.ServletMvcView;
import org.springframework.webflow.mvc.servlet.ServletMvcViewFactory;
import org.springframework.webflow.mvc.view.AbstractMvcView;
import org.springframework.webflow.mvc.view.AbstractMvcViewFactory;
import org.springframework.webflow.mvc.view.FlowViewResolver;
import org.springframework.webflow.validation.WebFlowMessageCodesResolver;

public class CasMvcViewFactoryCreator
extends MvcViewFactoryCreator {
    protected AbstractMvcViewFactory createMvcViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration) {
        Field field = ReflectionUtils.findField(MvcViewFactoryCreator.class, (String)"flowViewResolver", FlowViewResolver.class);
        Objects.requireNonNull(field).trySetAccessible();
        FlowViewResolver flowViewResolver = (FlowViewResolver)ReflectionUtils.getField((Field)field, (Object)((Object)this));
        return new CasServletMvcViewFactory(viewId, flowViewResolver, expressionParser, conversionService, binderConfiguration, (MessageCodesResolver)new WebFlowMessageCodesResolver());
    }

    private static class CasServletMvcViewFactory
    extends ServletMvcViewFactory {
        CasServletMvcViewFactory(Expression viewId, FlowViewResolver viewResolver, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration, MessageCodesResolver messageCodesResolver) {
            super(viewId, viewResolver, expressionParser, conversionService, binderConfiguration, messageCodesResolver);
        }

        protected AbstractMvcView createMvcView(View view, RequestContext context) {
            return new CasServletMvcView(view, context);
        }
    }

    private static class CasServletMvcView
    extends ServletMvcView {
        CasServletMvcView(View view, RequestContext context) {
            super(view, context);
        }

        protected String determineEventId(RequestContext context) {
            String eventId = super.determineEventId(context);
            if (StringUtils.isBlank((CharSequence)eventId)) {
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
                eventId = (String)request.getAttribute("_eventId");
            }
            return eventId;
        }

        protected MappingResults bind(Object model) {
            MappingResults initialMappingResults = super.bind(model);
            if (initialMappingResults.getAllResults().isEmpty() && !initialMappingResults.hasErrorResults()) {
                DefaultMapper mapper = new DefaultMapper();
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)this.getRequestContext());
                Spliterator spliterator = Spliterators.spliteratorUnknownSize(request.getAttributeNames().asIterator(), 0);
                LocalParameterMap parameterNames = new LocalParameterMap(StreamSupport.stream(spliterator, false).filter(attribute -> !attribute.contains(".")).filter(attribute -> Objects.nonNull(request.getAttribute(attribute))).collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getAttribute(arg_0))));
                this.addModelBindings(mapper, parameterNames.asMap().keySet(), model);
                return mapper.map((Object)parameterNames, model);
            }
            return initialMappingResults;
        }
    }
}

