/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.transaction.annotation.Transactional;

public class DefaultJobManager
implements JobManager,
SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    protected final DomainHolder<?> domainHolder;
    protected final SyncopeTaskScheduler scheduler;
    protected final JobStatusDAO jobStatusDAO;
    protected final TaskDAO taskDAO;
    protected final ReportDAO reportDAO;
    protected final ImplementationDAO implementationDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final ConfParamOps confParamOps;
    protected final SecurityProperties securityProperties;

    public DefaultJobManager(DomainHolder<?> domainHolder, SyncopeTaskScheduler scheduler, JobStatusDAO jobStatusDAO, TaskDAO taskDAO, ReportDAO reportDAO, ImplementationDAO implementationDAO, TaskUtilsFactory taskUtilsFactory, ConfParamOps confParamOps, SecurityProperties securityProperties) {
        this.domainHolder = domainHolder;
        this.scheduler = scheduler;
        this.jobStatusDAO = jobStatusDAO;
        this.taskDAO = taskDAO;
        this.reportDAO = reportDAO;
        this.implementationDAO = implementationDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.confParamOps = confParamOps;
        this.securityProperties = securityProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning(String jobName) {
        String string = jobName;
        synchronized (string) {
            boolean locked = this.jobStatusDAO.lock(jobName);
            if (locked) {
                this.jobStatusDAO.unlock(jobName);
            }
            return !locked;
        }
    }

    protected void registerJob(JobExecutionContext context, Class<? extends Job> jobClass, String cronExpression, OffsetDateTime startAt) {
        if (this.isRunning(context.getJobName())) {
            LOG.debug("Job {} already running, cancel", (Object)context.getJobName());
            return;
        }
        Job job = (Job)ApplicationContextProvider.getBeanFactory().createBean(jobClass);
        job.setContext(context);
        if (cronExpression == null && startAt == null) {
            this.scheduler.register(job);
        } else if (cronExpression == null) {
            this.scheduler.schedule(job, startAt.toInstant());
        } else {
            this.scheduler.schedule(job, new CronTrigger(cronExpression));
        }
    }

    protected void register(String domain, SchedTask task, String cronExpression, OffsetDateTime startAt, String executor, boolean dryRun, Map<String, Object> jobData) {
        Implementation jobDelegate;
        TaskType type = this.taskUtilsFactory.getInstance((Task)task).getType();
        if (!task.isActive()) {
            LOG.debug("{} Task {} {} not active, skipping job registration", new Object[]{type, task.getKey(), task.getName()});
            return;
        }
        Object object = task.getJobDelegate() == null ? (task instanceof PullTask ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter(impl -> PullJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : (task instanceof PushTask ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter(impl -> PushJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : null)) : (jobDelegate = task.getJobDelegate());
        if (jobDelegate == null) {
            throw new IllegalArgumentException("Task " + String.valueOf(task) + " does not provide any " + SchedTaskJobDelegate.class.getSimpleName());
        }
        JobExecutionContext context = new JobExecutionContext(domain, JobNamer.getJobName((Task)task), executor, dryRun);
        context.getData().put("taskType", type);
        context.getData().put("taskKey", task.getKey());
        context.getData().put("delegateImpl", jobDelegate.getKey());
        context.getData().putAll(jobData);
        this.registerJob(context, TaskJob.class, cronExpression, startAt);
    }

    public void execute(SchedTask task, OffsetDateTime startAt, String executor, boolean dryRun, Map<String, Object> jobData) {
        this.register(AuthContextUtils.getDomain(), task, null, startAt, executor, dryRun, jobData);
    }

    public void register(SchedTask task, String executor) {
        this.register(AuthContextUtils.getDomain(), task, task.getCronExpression(), null, executor, false, Map.of());
    }

    protected void register(String domain, Report report, String cronExpression, OffsetDateTime startAt, String executor, boolean dryRun) {
        if (!report.isActive()) {
            LOG.debug("Report {} {} not active, skipping job registration", (Object)report.getKey(), (Object)report.getName());
            return;
        }
        JobExecutionContext context = new JobExecutionContext(domain, JobNamer.getJobName((Report)report), executor, dryRun);
        context.getData().put("reportKey", report.getKey());
        context.getData().put("delegateImpl", report.getJobDelegate().getKey());
        this.registerJob(context, ReportJob.class, cronExpression, startAt);
    }

    public void execute(Report report, OffsetDateTime startAt, String executor, boolean dryRun) {
        this.register(AuthContextUtils.getDomain(), report, null, startAt, executor, dryRun);
    }

    public void register(Report report, String executor) {
        this.register(AuthContextUtils.getDomain(), report, report.getCronExpression(), null, executor, false);
    }

    protected void unregisterJob(String jobName) {
        this.scheduler.stop(AuthContextUtils.getDomain(), jobName);
        this.scheduler.delete(AuthContextUtils.getDomain(), jobName);
    }

    public void unregister(Task<?> task) {
        this.unregisterJob(JobNamer.getJobName(task));
    }

    public void unregister(Report report) {
        this.unregisterJob(JobNamer.getJobName((Report)report));
    }

    public int getOrder() {
        return 500;
    }

    @Transactional
    public void load(String domain) {
        AuthContextUtils.runAsAdmin((String)domain, () -> {
            HashSet tasks = new HashSet(this.taskDAO.findAll(TaskType.SCHEDULED));
            tasks.addAll(this.taskDAO.findAll(TaskType.PULL));
            tasks.addAll(this.taskDAO.findAll(TaskType.PUSH));
            tasks.addAll(this.taskDAO.findAll(TaskType.MACRO));
            tasks.addAll(this.taskDAO.findAll(TaskType.LIVE_SYNC));
            boolean loadException = false;
            Iterator it = tasks.iterator();
            while (it.hasNext() && !loadException) {
                SchedTask task = (SchedTask)it.next();
                LOG.debug("Loading job for {} Task {} {}", new Object[]{this.taskUtilsFactory.getInstance((Task)task).getType(), task.getKey(), task.getName()});
                try {
                    this.register(domain, task, task.getCronExpression(), null, this.securityProperties.getAdminUser(), false, Map.of());
                }
                catch (Exception e) {
                    LOG.error("While loading job instance for task {}", (Object)task.getKey(), (Object)e);
                    loadException = true;
                }
            }
            loadException = false;
            it = this.reportDAO.findAll().iterator();
            while (it.hasNext() && !loadException) {
                Report report = (Report)it.next();
                LOG.debug("Loading job for Report {} {}", (Object)report.getKey(), (Object)report.getName());
                try {
                    this.register(domain, report, report.getCronExpression(), null, this.securityProperties.getAdminUser(), false);
                }
                catch (Exception e) {
                    LOG.error("While loading job instance for report {}", (Object)report.getName(), (Object)e);
                    loadException = true;
                }
            }
        });
        if ("Master".equals(domain)) {
            JobExecutionContext context;
            String notificationJobCronExp = (String)AuthContextUtils.callAsAdmin((String)"Master", () -> {
                String result = "";
                String conf = (String)this.confParamOps.get("Master", "notificationjob.cronExpression", null, String.class);
                if (conf == null) {
                    result = "0 0/5 * * * ?";
                } else if (!"".equals(conf)) {
                    result = conf;
                }
                return result;
            });
            if (StringUtils.isBlank((CharSequence)notificationJobCronExp)) {
                LOG.debug("Empty value provided for {}'s cron, not scheduling", (Object)NotificationJob.class.getSimpleName());
            } else {
                LOG.debug("{}'s cron expression: {} - scheduling", (Object)NotificationJob.class.getSimpleName(), (Object)notificationJobCronExp);
                context = new JobExecutionContext(domain, "notificationJob", this.securityProperties.getAdminUser(), false);
                try {
                    this.registerJob(context, NotificationJob.class, notificationJobCronExp, null);
                }
                catch (Exception e) {
                    LOG.error("While loading {} instance", (Object)NotificationJob.class.getSimpleName(), (Object)e);
                }
            }
            LOG.debug("Registering {}", SystemLoadReporterJob.class);
            context = new JobExecutionContext(domain, StringUtils.uncapitalize((String)SystemLoadReporterJob.class.getSimpleName()), this.securityProperties.getAdminUser(), false);
            try {
                this.registerJob(context, SystemLoadReporterJob.class, "0 * * * * ?", null);
            }
            catch (Exception e) {
                LOG.error("While loading {} instance", (Object)SystemLoadReporterJob.class.getSimpleName(), (Object)e);
            }
        }
    }

    public void unload(String domain) {
        AuthContextUtils.runAsAdmin((String)domain, () -> {
            HashSet tasks = new HashSet(this.taskDAO.findAll(TaskType.SCHEDULED));
            tasks.addAll(this.taskDAO.findAll(TaskType.PULL));
            tasks.addAll(this.taskDAO.findAll(TaskType.PUSH));
            tasks.addAll(this.taskDAO.findAll(TaskType.MACRO));
            tasks.addAll(this.taskDAO.findAll(TaskType.LIVE_SYNC));
            tasks.forEach(task -> {
                LOG.debug("Unloading job for {} Task {} {}", new Object[]{this.taskUtilsFactory.getInstance((Task)task).getType(), task.getKey(), task.getName()});
                try {
                    this.unregister((Task<?>)task);
                }
                catch (Exception e) {
                    LOG.error("While unloading job for task {}", (Object)task.getKey(), (Object)e);
                }
            });
            this.reportDAO.findAll().forEach(report -> {
                LOG.debug("Unloading job for Report {} {}", (Object)report.getKey(), (Object)report.getName());
                try {
                    this.unregister((Report)report);
                }
                catch (Exception e) {
                    LOG.error("While unloading job for report {}", (Object)report.getName(), (Object)e);
                }
            });
        });
    }
}

