/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.lang.management.ManagementFactory;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SanitizerTest {
    @Test
    public void testSanitize() {
        String principal = "CN=Some characters !@#$%&*()_-+=';:,/~";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assertions.assertTrue((boolean)sanitizedPrincipal.replace('%', '_').matches("[a-zA-Z0-9\\._\\-]+"));
        Assertions.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
    }

    @Test
    public void testJmxSanitize() throws MalformedObjectNameException {
        int unquoted = 0;
        for (int i = 0; i < 65536; ++i) {
            char c = (char)i;
            String value = "value" + c;
            String jmxSanitizedValue = Sanitizer.jmxSanitize((String)value);
            if (jmxSanitizedValue.equals(value)) {
                ++unquoted;
            }
            this.verifyJmx(jmxSanitizedValue, i);
            String encodedValue = Sanitizer.sanitize((String)value);
            this.verifyJmx(encodedValue, i);
            Assertions.assertEquals((Object)encodedValue, (Object)Sanitizer.jmxSanitize((String)encodedValue));
        }
        Assertions.assertEquals((int)68, (int)unquoted);
    }

    private void verifyJmx(String sanitizedValue, int c) throws MalformedObjectNameException {
        TestStat mbean = new TestStat();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("test:key=" + sanitizedValue);
        try {
            server.registerMBean(mbean, objectName);
            server.unregisterMBean(objectName);
        }
        catch (MBeanException | OperationsException e) {
            Assertions.fail((String)("Could not register char=\\u" + c));
        }
    }

    public static class TestStat
    implements TestStatMBean {
        @Override
        public int getValue() {
            return 1;
        }
    }

    public static interface TestStatMBean {
        public int getValue();
    }
}

