/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.apache.syncope.core.persistence.api.validation.OIDCC4UIProviderCheck;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;

public class OIDCC4UIProviderValidator
extends AbstractValidator<OIDCC4UIProviderCheck, OIDCC4UIProvider> {
    public boolean isValid(OIDCC4UIProvider oidcProvider, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (OIDCC4UIProviderValidator.isHtml((String)oidcProvider.getKey())) {
            context.buildConstraintViolationWithTemplate(OIDCC4UIProviderValidator.getTemplate((EntityViolationType)EntityViolationType.InvalidKey, (String)oidcProvider.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        if (oidcProvider.isSelfRegUnmatching() && oidcProvider.isCreateUnmatching()) {
            context.buildConstraintViolationWithTemplate(OIDCC4UIProviderValidator.getTemplate((EntityViolationType)EntityViolationType.Standard, (String)"Either selfRegUnmatching or createUnmatching, not both")).addPropertyNode("selfRegUnmatching").addPropertyNode("createUnmatching").addConstraintViolation();
            return false;
        }
        long connObjectKeys = oidcProvider.getItems().stream().filter(Item::isConnObjectKey).count();
        if (!oidcProvider.getItems().isEmpty() && connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(OIDCC4UIProviderValidator.getTemplate((EntityViolationType)EntityViolationType.InvalidMapping, (String)"Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        boolean[] isValid = new boolean[]{true};
        long passwords = oidcProvider.getItems().stream().filter(Item::isPassword).count();
        if (passwords > 0L) {
            context.buildConstraintViolationWithTemplate(OIDCC4UIProviderValidator.getTemplate((EntityViolationType)EntityViolationType.InvalidMapping, (String)"No password mapping is allowed")).addPropertyNode("password.size").addConstraintViolation();
            isValid[0] = false;
        }
        return isValid[0];
    }
}

