/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class DefaultRegisteredServicesTemplatesManager
implements RegisteredServicesTemplatesManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServicesTemplatesManager.class);
    private final Collection<File> templateDefinitionFiles;
    private final StringSerializer<RegisteredService> registeredServiceSerializer;

    public DefaultRegisteredServicesTemplatesManager(ServiceRegistryProperties properties, StringSerializer<RegisteredService> registeredServiceSerializer) {
        this.registeredServiceSerializer = registeredServiceSerializer;
        Resource location = properties.getTemplates().getDirectory().getLocation();
        LOGGER.debug("Attempting to locate service template definitions from [{}]", (Object)location);
        this.templateDefinitionFiles = (Collection)FunctionUtils.doUnchecked(() -> ResourceUtils.doesResourceExist((Resource)location) ? FileUtils.listFiles((File)location.getFile(), (String[])new String[]{"json"}, (boolean)true) : new ArrayList());
        LOGGER.trace("Found [{}] template registered service definition(s)", (Object)this.templateDefinitionFiles.size());
    }

    public RegisteredService apply(RegisteredService registeredService) {
        String[] templateNames;
        if (this.templateDefinitionFiles.isEmpty() || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getTemplateName())) {
            LOGGER.trace("Registered service template directory contains no template definitions, or registered service [{}] does specify template name(s)", (Object)registeredService.getName());
            return registeredService;
        }
        RegisteredService mergeResult = null;
        for (String templateName : templateNames = StringUtils.commaDelimitedListToStringArray((String)registeredService.getTemplateName().trim())) {
            Optional<RegisteredService> templateDefinition = this.locateTemplateServiceDefinition(registeredService, templateName);
            if (templateDefinition.isEmpty()) {
                LOGGER.warn("Registered service template definition [{}] cannot be found and is not applicable to [{}]", (Object)templateName, (Object)registeredService.getName());
                continue;
            }
            RegisteredService templateService = templateDefinition.get();
            LOGGER.trace("Applying template service definition [{}] to service [{}]", (Object)templateService, (Object)registeredService.getName());
            mergeResult = (RegisteredService)this.registeredServiceSerializer.merge((Object)templateService, (Object)Objects.requireNonNullElse(mergeResult, registeredService));
            LOGGER.debug("Resulting service definition after merging with template [{}] is:\n[{}]", (Object)templateService.getTemplateName(), (Object)mergeResult);
        }
        return Objects.requireNonNullElse(mergeResult, registeredService);
    }

    private Optional<RegisteredService> locateTemplateServiceDefinition(RegisteredService registeredService, String templateName) {
        ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        return this.templateDefinitionFiles.stream().filter(__ -> CasRuntimeHintsRegistrar.notInNativeImage()).filter(arg_0 -> this.registeredServiceSerializer.supports(arg_0)).filter(file -> FilenameUtils.getBaseName((String)file.getAbsolutePath()).equalsIgnoreCase(templateName)).map(file -> (RegisteredService)FunctionUtils.doUnchecked(() -> {
            Map<String, Serializable> templateParams = registeredService.getProperties().entrySet().stream().map(entry -> {
                ArrayList listOfValues = new ArrayList(((RegisteredServiceProperty)entry.getValue()).getValues());
                ArrayList values = listOfValues.size() == 1 ? (Serializable)listOfValues.getFirst() : listOfValues;
                return Pair.of((Object)((String)entry.getKey()), values);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String template = scriptFactory.createTemplate(file, templateParams);
            return (RegisteredService)this.registeredServiceSerializer.from(template);
        })).sorted(Comparator.comparingInt(RegisteredService::getEvaluationOrder)).filter(templateService -> templateService.getClass().equals(registeredService.getClass()) && templateService.getTemplateName().equalsIgnoreCase(templateName)).findFirst();
    }

    @Generated
    public DefaultRegisteredServicesTemplatesManager(Collection<File> templateDefinitionFiles, StringSerializer<RegisteredService> registeredServiceSerializer) {
        this.templateDefinitionFiles = templateDefinitionFiles;
        this.registeredServiceSerializer = registeredServiceSerializer;
    }
}

