/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.apereo.cas.web.BrowserStorage;
import org.apereo.cas.web.DefaultBrowserStorage;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.session.JEESessionStore;

public class BrowserWebStorageSessionStore
extends JEESessionStore {
    private final CipherExecutor webflowCipherExecutor;
    private final String browserStorageContextKey;

    public Optional<Object> getTrackableSession(WebContext context) {
        Optional currentSession = super.getTrackableSession(context);
        LinkedHashMap attributes = new LinkedHashMap();
        currentSession.map(HttpSession.class::cast).ifPresent(session -> {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = session.getAttribute(name);
                if (value == null) continue;
                attributes.put(name, value);
            }
        });
        byte[] encoded = SerializationUtils.serializeAndEncodeObject((EncodableCipher)this.webflowCipherExecutor, attributes);
        String trackableSession = new String(encoded, StandardCharsets.UTF_8);
        return Optional.of(DefaultBrowserStorage.builder().context(this.browserStorageContextKey).storageType(BrowserStorage.BrowserStorageTypes.LOCAL).build().setPayloadJson(Map.of("context", trackableSession)));
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        String string;
        DefaultBrowserStorage.DefaultBrowserStorageBuilder defaultBrowserStorageBuilder = DefaultBrowserStorage.builder().storageType(BrowserStorage.BrowserStorageTypes.LOCAL).context(this.browserStorageContextKey);
        if (trackableSession instanceof BrowserStorage) {
            BrowserStorage bs = (BrowserStorage)trackableSession;
            string = bs.getPayload();
        } else {
            string = trackableSession.toString();
        }
        byte[] encoded = defaultBrowserStorageBuilder.payload(string).build().getPayloadJson().get("context").toString().getBytes(StandardCharsets.UTF_8);
        Map attributes = (Map)((Object)SerializationUtils.decodeAndDeserializeObject((byte[])encoded, (DecodableCipher)this.webflowCipherExecutor, LinkedHashMap.class));
        attributes.forEach((key, value) -> this.set(context, (String)key, value));
        context.setRequestAttribute("sessionStorageAttributes", (Object)attributes);
        return Optional.of(this);
    }

    public Map<String, Object> getSessionAttributes(WebContext context) {
        return context.getRequestAttribute("sessionStorageAttributes", Map.class).orElseGet(LinkedHashMap::new);
    }

    @CanIgnoreReturnValue
    public SessionStore withSessionAttributes(WebContext context, Map<String, Object> properties) {
        properties.forEach((key, value) -> this.set(context, (String)key, value));
        return this;
    }

    @Generated
    public BrowserWebStorageSessionStore(CipherExecutor webflowCipherExecutor, String browserStorageContextKey) {
        this.webflowCipherExecutor = webflowCipherExecutor;
        this.browserStorageContextKey = browserStorageContextKey;
    }

    @Generated
    public CipherExecutor getWebflowCipherExecutor() {
        return this.webflowCipherExecutor;
    }

    @Generated
    public String getBrowserStorageContextKey() {
        return this.browserStorageContextKey;
    }
}

