/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.Collection;
import kafka.security.authorizer.AclAuthorizer;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.security.authorizer.AclEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\b\u0010\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005\u0002}AQA\u0013\u0001\u0005\u0002-CQa\u001b\u0001\u0005\u00021DQa\u001c\u0001\u0005\u0002ADQ\u0001 \u0001\u0005\u0002ADQA \u0001\u0005\u0002}Da\u0001\u0011\u0001\u0005\u0002\u0005%\u0001\"CA%\u0001E\u0005I\u0011AA&\u0011%\t\t\u0007AI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002j!1\u0011Q\u000e\u0001\u0005\u0002ADa!!\u001d\u0001\t\u0003\u0001(\u0001\u0007.l\u0003\u000edW*[4sCRLwN\\\"mS\u0016tG\u000fV3ti*\u0011\u0001#E\u0001\n[&<'/\u0019;j_:T!AE\n\u0002\u0005i\\'\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0006\t\u00031ei\u0011aD\u0005\u00035=\u0011aCW6NS\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"\u0001\u0007\u0001\u0002)5LwM]1uK\u0006\u001bGn]!oIZ+'/\u001b4z)\r\u0001ce\f\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG\u000fC\u0003(\u0005\u0001\u0007\u0001&\u0001\u0006bkRDwN]5{KJ\u0004\"!K\u0017\u000e\u0003)R!aJ\u0016\u000b\u00051\u001a\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u00059R#!D!dY\u0006+H\u000f[8sSj,'\u000fC\u00031\u0005\u0001\u0007\u0011'\u0001\u0003bG2\u001c\bc\u0001\u001a;{9\u00111\u0007\u000f\b\u0003i]j\u0011!\u000e\u0006\u0003mU\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0005e\u0012\u0013a\u00029bG.\fw-Z\u0005\u0003wq\u00121aU3r\u0015\tI$\u0005\u0005\u0002?\u00116\tqH\u0003\u0002A\u0003\u0006\u0019\u0011m\u00197\u000b\u0005\t\u001b\u0015AB2p[6|gN\u0003\u0002\u0015\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tIuH\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001e\f\u0001E]3qY\u0006\u001cW-Q2mg\u0006sGMU3bI^KG\u000f[!vi\"|'/\u001b>feR)A\nV+^GB\u0019Q*U\u001f\u000f\u00059{\u0005C\u0001\u001b#\u0013\t\u0001&%\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u00131aU3u\u0015\t\u0001&\u0005C\u0003(\u0007\u0001\u0007\u0001\u0006C\u0003W\u0007\u0001\u0007q+A\bsKN|WO]2f!\u0006$H/\u001a:o!\tA6,D\u0001Z\u0015\tQ\u0016)\u0001\u0005sKN|WO]2f\u0013\ta\u0016LA\bSKN|WO]2f!\u0006$H/\u001a:o\u0011\u0015q6\u00011\u0001`\u0003\u0011\t7-Z:\u0011\u0007IR\u0004\r\u0005\u0002?C&\u0011!m\u0010\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010C\u0003e\u0007\u0001\u0007Q-\u0001\u0003qe\u0016$\u0007\u0003B\u0011g\u0019\"L!a\u001a\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u0011j\u0013\tQ'EA\u0004C_>dW-\u00198\u0002G\u0011,G.\u001a;f%\u0016\u001cx.\u001e:dK\u0006sGMU3bI^KG\u000f[!vi\"|'/\u001b>feR\u0019\u0001%\u001c8\t\u000b\u001d\"\u0001\u0019\u0001\u0015\t\u000bY#\u0001\u0019A,\u00027Q,7\u000f^!dYNl\u0015n\u001a:bi\u0016\fe\u000e\u001a#vC2<&/\u001b;f)\u0005\u0001\u0003FA\u0003s!\t\u0019(0D\u0001u\u0015\t)h/A\u0002ba&T!a\u001e=\u0002\u000f),\b/\u001b;fe*\u0011\u0011PR\u0001\u0006UVt\u0017\u000e^\u0005\u0003wR\u0014A\u0001V3ti\u0006IB/Z:u\u0003\u000ed7o\u00115b]\u001e,7/\u00138T]\u0006\u00048\u000f[8uQ\t1!/\u0001\u0003vg\u0016\u0014H\u0003BA\u0001\u0003\u000f\u00012!TA\u0002\u0013\r\t)a\u0015\u0002\u0007'R\u0014\u0018N\\4\t\ry<\u0001\u0019AA\u0001)A\tY!a\u0006\u0002\u001c\u0005\u0015\u0012QFA\u0019\u0003k\ty\u0004\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\"Q\u0001\t[\u0016$\u0018\rZ1uC&!\u0011QCA\b\u0005a\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=SK\u000e|'\u000f\u001a\u0005\b\u00033A\u0001\u0019AA\u0001\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u001d\ti\u0002\u0003a\u0001\u0003?\tAB]3t_V\u00148-\u001a+za\u0016\u00042\u0001WA\u0011\u0013\r\t\u0019#\u0017\u0002\r%\u0016\u001cx.\u001e:dKRK\b/\u001a\u0005\u0007-\"\u0001\r!a\n\u0011\u0007a\u000bI#C\u0002\u0002,e\u00131\u0002U1ui\u0016\u0014h\u000eV=qK\"9\u0011q\u0006\u0005A\u0002\u0005\u0005\u0011!\u00039sS:\u001c\u0017\u000e]1m\u0011%\t\u0019\u0004\u0003I\u0001\u0002\u0004\t\t!\u0001\u0003i_N$\b\"CA\u001c\u0011A\u0005\t\u0019AA\u001d\u0003%y\u0007/\u001a:bi&|g\u000eE\u0002?\u0003wI1!!\u0010@\u00051\t5\r\\(qKJ\fG/[8o\u0011%\t\t\u0005\u0003I\u0001\u0002\u0004\t\u0019%\u0001\bqKJl\u0017n]:j_:$\u0016\u0010]3\u0011\u0007y\n)%C\u0002\u0002H}\u0012\u0011#Q2m!\u0016\u0014X.[:tS>tG+\u001f9f\u00035\t7\r\u001c\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\n\u0016\u0005\u0003\u0003\tye\u000b\u0002\u0002RA!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013!C;oG\",7m[3e\u0015\r\tYFI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA0\u0003+\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\t7\r\u001c\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\r\u0016\u0005\u0003s\ty%A\u0007bG2$C-\u001a4bk2$HeN\u000b\u0003\u0003WRC!a\u0011\u0002P\u00051B/Z:u\t\u0016dW\r^3P]\u0016\f5\r\\(g\u001b\u0006t\u0017\u0010\u000b\u0002\re\u00061B/Z:u\u0003\u000edW\u000b\u001d3bi\u0016\fe\u000e\u001a#fY\u0016$X\r\u000b\u0002\u000ee\u0002")
public class ZkAclMigrationClientTest
extends ZkMigrationTestHarness {
    public void migrateAclsAndVerify(AclAuthorizer authorizer, Seq<AclBinding> acls) {
        authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava(acls).asJava());
        ArrayBuffer batches = new ArrayBuffer();
        this.migrationClient().migrateAcls(batch -> batches.append((Object)CollectionConverters$.MODULE$.ListHasAsScala(batch).asScala()));
        ArrayBuffer records = (ArrayBuffer)((StrictOptimizedIterableOps)batches.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> (AccessControlEntryRecord)x$1.message());
        Assertions.assertEquals((int)acls.size(), (int)records.size(), (String)"Expected one record for each ACLBinding");
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AclBinding> replaceAclsAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern, Seq<AccessControlEntry> aces, Function1<scala.collection.immutable.Set<AclBinding>, Object> pred) {
        void var7_11;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().writeResourceAcls(resourcePattern, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(aces).asJava(), this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply((Object)(computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$replaceAclsAndReadWithAuthorizer$1(authorizer, resourceFilter))))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp());
        return var7_11;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteResourceAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        void var5_9;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().deleteResource(resourcePattern, this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$deleteResourceAndReadWithAuthorizer$1(authorizer, resourceFilter)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean ok = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var5_9);
    }

    @Test
    public void testAclsMigrateAndDualWrite() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry.WILDCARD_PRINCIPAL_STRING);
        AccessControlEntry ace1 = new AccessControlEntry(principal.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding acl1 = new AclBinding(resource1, ace1);
        AccessControlEntry ace2 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
        AclBinding acl2 = new AclBinding(resource1, ace2);
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)this.zkConnect())}))).asJava());
            this.migrateAclsAndVerify(authorizer, (Seq<AclBinding>)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$)))));
            Assertions.assertTrue((boolean)this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)ace1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$1(acls))).contains((Object)acl1));
            this.deleteResourceAndReadWithAuthorizer(authorizer, resource1);
            AccessControlEntry newAce1 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Assertions.assertTrue((boolean)((SetOps)this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)newAce1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$2(acls))).map((Function1 & Serializable)x$4 -> x$4.entry())).contains((Object)newAce1));
            AccessControlEntry newAce2 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Assertions.assertTrue((boolean)((SetOps)this.replaceAclsAndReadWithAuthorizer(authorizer, resource2, (Seq<AccessControlEntry>)new .colon.colon((Object)acl3.entry(), (List)new .colon.colon((Object)newAce2, (List)Nil$.MODULE$)), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$4(acls))).map((Function1 & Serializable)x$5 -> x$5.entry())).subsetOf((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3.entry(), newAce2}))));
        }
    }

    @Test
    public void testAclsChangesInSnapshot() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("baz-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        String username1 = "alice";
        String username2 = "blah";
        KafkaPrincipal principal1 = new KafkaPrincipal("User", username1);
        KafkaPrincipal principal2 = new KafkaPrincipal("User", username2);
        AclEntry acl1Resource1 = new AclEntry(new AccessControlEntry(principal1.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclEntry acl1Resource2 = new AclEntry(new AccessControlEntry(principal2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.zkClient().createAclPaths();
        this.zkClient().createAclsForResourceIfNotExists(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource1})));
        this.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource2})));
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        AccessControlEntryRecord acl1Resource3 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.10.1").setOperation(AclOperation.READ.code()).setPrincipal(AclEntry.WILDCARD_PRINCIPAL_STRING).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource3.patternType().code()).setResourceName(resource3.name()).setResourceType(resource3.resourceType().code());
        delta.replay(acl1Resource3);
        AccessControlEntryRecord acl2Resource1 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.15.1").setOperation(AclOperation.WRITE.code()).setPrincipal(principal1.toString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource1.patternType().code()).setResourceName(resource1.name()).setResourceType(resource1.resourceType().code());
        delta.replay(acl2Resource1);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), x$6 -> Assertions.fail((String)x$6)).handleSnapshot(image, (x$7, x$8, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set resource1AclsInZk = this.zkClient().getVersionedAclsForResource(resource1).acls();
        Assertions.assertEquals((int)1, (int)resource1AclsInZk.size());
        Assertions.assertEquals((Object)new AccessControlEntry(acl2Resource1.principal(), acl2Resource1.host(), AclOperation.fromCode((byte)acl2Resource1.operation()), AclPermissionType.fromCode((byte)acl2Resource1.permissionType())), (Object)((AclEntry)resource1AclsInZk.head()).ace);
        Assertions.assertTrue((boolean)this.zkClient().getVersionedAclsForResource(resource2).acls().isEmpty());
        scala.collection.immutable.Set resource3AclsInZk = this.zkClient().getVersionedAclsForResource(resource3).acls();
        Assertions.assertEquals((Object)new AccessControlEntry(acl1Resource3.principal(), acl1Resource3.host(), AclOperation.fromCode((byte)acl1Resource3.operation()), AclPermissionType.fromCode((byte)acl1Resource3.permissionType())), (Object)((AclEntry)resource3AclsInZk.head()).ace);
    }

    public String user(String user) {
        return new KafkaPrincipal("User", user).toString();
    }

    public AccessControlEntryRecord acl(String resourceName, ResourceType resourceType, PatternType resourcePattern, String principal, String host, AclOperation operation, AclPermissionType permissionType) {
        return new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost(host).setOperation(operation.code()).setPrincipal(principal).setPermissionType(permissionType.code()).setPatternType(resourcePattern.code()).setResourceName(resourceName).setResourceType(resourceType.code());
    }

    public String acl$default$5() {
        return "*";
    }

    public AclOperation acl$default$6() {
        return AclOperation.READ;
    }

    public AclPermissionType acl$default$7() {
        return AclPermissionType.ALLOW;
    }

    @Test
    public void testDeleteOneAclOfMany() {
        this.zkClient().createAclPaths();
        String topicName = new StringBuilder(6).append("topic-").append(Uuid.randomUuid()).toString();
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        AccessControlEntryRecord acl1 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl2 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl3 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        delta.replay(acl1);
        delta.replay(acl2);
        delta.replay(acl3);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        Buffer errorLogs = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        KRaftMigrationZkWriter kraftMigrationZkWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), msg -> errorLogs.append(msg));
        kraftMigrationZkWriter.handleSnapshot(image, (x$9, x$10, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set aclsInZk = this.zkClient().getVersionedAclsForResource(resource).acls();
        Assertions.assertEquals((int)3, (int)aclsInZk.size());
        MetadataDelta delta2 = new MetadataDelta.Builder().setImage(image).build();
        delta2.replay(new RemoveAccessControlEntryRecord().setId(acl3.id()));
        MetadataImage image2 = delta2.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image, image2, delta2, (x$11, x$12, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set aclsInZk2 = this.zkClient().getVersionedAclsForResource(resource).acls();
        Assertions.assertEquals((int)2, (int)aclsInZk2.size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
        AccessControlEntryRecord acl4 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        delta2.replay(acl4);
        MetadataImage image3 = delta2.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image3, image3, delta2, (x$13, x$14, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set aclsInZk3 = this.zkClient().getVersionedAclsForResource(resource).acls();
        Assertions.assertEquals((int)3, (int)aclsInZk3.size());
        Assertions.assertEquals((int)1, (int)errorLogs.size());
        Assertions.assertEquals((Object)new StringBuilder(69).append("Cannot delete ACL ").append(acl3.id()).append(" from ZK since it is missing from previous AclImage").toString(), (Object)errorLogs.head());
    }

    @Test
    public void testAclUpdateAndDelete() {
        this.zkClient().createAclPaths();
        Buffer errorLogs = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        KRaftMigrationZkWriter kraftMigrationZkWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), msg -> errorLogs.append(msg));
        String topicName = new StringBuilder(6).append("topic-").append(Uuid.randomUuid()).toString();
        String otherName = new StringBuilder(6).append("other-").append(Uuid.randomUuid()).toString();
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.PREFIXED);
        ResourcePattern otherResource = new ResourcePattern(ResourceType.TOPIC, otherName, PatternType.LITERAL);
        AccessControlEntryRecord acl1 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl2 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl3 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl4 = this.acl(topicName, ResourceType.TOPIC, PatternType.LITERAL, this.user("dave"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        MetadataDelta delta1 = new MetadataDelta(MetadataImage.EMPTY);
        delta1.replay(acl1);
        delta1.replay(acl2);
        delta1.replay(acl3);
        delta1.replay(acl4);
        MetadataImage image1 = delta1.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(MetadataImage.EMPTY, image1, delta1, (x$15, x$16, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)4, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        Assertions.assertEquals((int)0, (int)this.zkClient().getVersionedAclsForResource(prefixedResource).acls().size());
        Assertions.assertEquals((int)0, (int)this.zkClient().getVersionedAclsForResource(otherResource).acls().size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
        AccessControlEntryRecord acl5 = this.acl(topicName, ResourceType.TOPIC, PatternType.PREFIXED, this.user("alice"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl6 = this.acl(topicName, ResourceType.TOPIC, PatternType.PREFIXED, this.user("bob"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl7 = this.acl(otherName, ResourceType.TOPIC, PatternType.LITERAL, this.user("carol"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        AccessControlEntryRecord acl8 = this.acl(otherName, ResourceType.TOPIC, PatternType.LITERAL, this.user("dave"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        MetadataDelta delta2 = new MetadataDelta.Builder().setImage(image1).build();
        delta2.replay(acl5);
        delta2.replay(acl6);
        delta2.replay(acl7);
        delta2.replay(acl8);
        delta2.replay(new RemoveAccessControlEntryRecord().setId(acl1.id()));
        MetadataImage image2 = delta2.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image1, image2, delta2, (x$17, x$18, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        Assertions.assertEquals((int)2, (int)this.zkClient().getVersionedAclsForResource(prefixedResource).acls().size());
        Assertions.assertEquals((int)2, (int)this.zkClient().getVersionedAclsForResource(otherResource).acls().size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
        AccessControlEntryRecord acl9 = this.acl(otherName, ResourceType.TOPIC, PatternType.LITERAL, this.user("eve"), this.acl$default$5(), this.acl$default$6(), this.acl$default$7());
        MetadataDelta delta3 = new MetadataDelta.Builder().setImage(image2).build();
        delta3.replay(acl1);
        delta3.replay(new RemoveAccessControlEntryRecord().setId(acl2.id()));
        delta3.replay(new RemoveAccessControlEntryRecord().setId(acl5.id()));
        delta3.replay(new RemoveAccessControlEntryRecord().setId(acl6.id()));
        delta3.replay(acl9);
        MetadataImage image3 = delta3.apply(MetadataProvenance.EMPTY);
        kraftMigrationZkWriter.handleDelta(image2, image3, delta3, (x$19, x$20, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(literalResource).acls().size());
        Assertions.assertEquals((int)0, (int)this.zkClient().getVersionedAclsForResource(prefixedResource).acls().size());
        Assertions.assertEquals((int)3, (int)this.zkClient().getVersionedAclsForResource(otherResource).acls().size());
        Assertions.assertEquals((int)0, (int)errorLogs.size());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$replaceAclsAndReadWithAuthorizer$1(AclAuthorizer authorizer$1, AclBindingFilter resourceFilter$1) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(resourceFilter$1)).asScala().toSet();
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$deleteResourceAndReadWithAuthorizer$1(AclAuthorizer authorizer$2, AclBindingFilter resourceFilter$2) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$2.acls(resourceFilter$2)).asScala().toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$1(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$2(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$4(scala.collection.immutable.Set acls) {
        return acls.size() == 2;
    }

    public static final /* synthetic */ Object $anonfun$deleteResourceAndReadWithAuthorizer$2$adapted(scala.collection.immutable.Set x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty());
    }
}

