/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.bpmn.behavior.BoundaryEventRegistryEventActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.ActivityWithMigrationContextBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.interceptor.MigrationContext;
import org.flowable.engine.logging.LogMDC;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueProcessOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContinueProcessOperation.class);
    protected boolean forceSynchronousOperation;
    protected boolean inCompensation;
    protected MigrationContext migrationContext;

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation, boolean inCompensation, MigrationContext migrationContext) {
        super(commandContext, execution);
        this.forceSynchronousOperation = forceSynchronousOperation;
        this.inCompensation = inCompensation;
        this.migrationContext = migrationContext;
    }

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution) {
        this(commandContext, execution, false, false, null);
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof FlowNode) {
            this.continueThroughFlowNode((FlowNode)currentFlowElement);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.continueThroughSequenceFlow((SequenceFlow)currentFlowElement);
        } else {
            throw new FlowableException("Programmatic error: no current flow element found or invalid type: " + String.valueOf(currentFlowElement) + ". For " + String.valueOf(this.execution) + ". Halting.");
        }
    }

    protected void executeProcessStartExecutionListeners() {
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId());
        this.executeExecutionListeners((HasExecutionListeners)process, this.execution.getParent(), "start");
    }

    protected void continueThroughFlowNode(FlowNode flowNode) {
        this.execution.setActive(true);
        if (flowNode.getIncomingFlows() != null && flowNode.getIncomingFlows().size() == 0 && flowNode.getSubProcess() == null) {
            this.executeProcessStartExecutionListeners();
        }
        if (!this.forceSynchronousOperation && flowNode instanceof SubProcess) {
            this.createChildExecutionForSubProcess((SubProcess)flowNode);
        }
        if (flowNode instanceof Activity && ((Activity)flowNode).hasMultiInstanceLoopCharacteristics()) {
            this.executeMultiInstanceSynchronous(flowNode);
        } else if (this.forceSynchronousOperation || !flowNode.isAsynchronous()) {
            this.executeSynchronous(flowNode);
        } else {
            this.executeAsynchronous(flowNode);
        }
    }

    protected void createChildExecutionForSubProcess(SubProcess subProcess) {
        ExecutionEntity parentScopeExecution = this.findFirstParentScopeExecution(this.execution);
        ExecutionEntity subProcessExecution = CommandContextUtil.getExecutionEntityManager(this.commandContext).createChildExecution(parentScopeExecution);
        subProcessExecution.setCurrentFlowElement((FlowElement)subProcess);
        subProcessExecution.setScope(true);
        CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteRelatedDataForExecution(this.execution, null, false);
        CommandContextUtil.getExecutionEntityManager(this.commandContext).delete(this.execution);
        this.execution = subProcessExecution;
    }

    protected void executeSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordActivityStart(this.execution);
        if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            try {
                this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
            }
            catch (BpmnError bpmnError) {
                ErrorPropagation.propagateError(bpmnError, (DelegateExecution)this.execution);
                return;
            }
        }
        List<ExecutionEntity> boundaryEventExecutions = null;
        List boundaryEvents = null;
        if (!this.inCompensation && flowNode instanceof Activity && CollectionUtil.isNotEmpty((Collection)(boundaryEvents = ((Activity)flowNode).getBoundaryEvents()))) {
            boundaryEventExecutions = this.createBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) != null) {
            this.executeActivityBehavior(activityBehavior, flowNode);
            this.executeBoundaryEvents(boundaryEvents, boundaryEventExecutions);
        } else {
            this.executeBoundaryEvents(boundaryEvents, boundaryEventExecutions);
            LOGGER.debug("No activityBehavior on activity '{}' with execution {}", (Object)flowNode.getId(), (Object)this.execution.getId());
            CommandContextUtil.getAgenda().planTakeOutgoingSequenceFlowsOperation(this.execution, true);
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = JobUtil.createJob(this.execution, (BaseElement)flowNode, "async-continuation", processEngineConfiguration);
        jobService.createAsyncJob(job, flowNode.isExclusive());
        jobService.scheduleAsyncJob(job);
        if (processEngineConfiguration.isLoggingSessionEnabled()) {
            BpmnLoggingSessionUtil.addAsyncActivityLoggingData("Created async job for " + flowNode.getId() + ", with job id " + job.getId(), "serviceTaskAsyncJob", job, (FlowElement)flowNode, this.execution);
        }
    }

    protected void executeMultiInstanceSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        if (!this.hasMultiInstanceRootExecution(this.execution, flowNode)) {
            this.execution = this.createMultiInstanceRootExecution(this.execution);
        }
        if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            try {
                this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
            }
            catch (BpmnError bpmnError) {
                ErrorPropagation.propagateError(bpmnError, (DelegateExecution)this.execution);
                return;
            }
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) != null) {
            this.executeActivityBehavior(activityBehavior, flowNode);
            if (this.execution.isMultiInstanceRoot() && !this.execution.isDeleted() && !this.execution.isEnded()) {
                List<ExecutionEntity> boundaryEventExecutions = null;
                List boundaryEvents = null;
                if (!this.inCompensation && flowNode instanceof Activity && CollectionUtil.isNotEmpty((Collection)(boundaryEvents = ((Activity)flowNode).getBoundaryEvents()))) {
                    boundaryEventExecutions = this.createBoundaryEvents(boundaryEvents, this.execution);
                }
                this.executeBoundaryEvents(boundaryEvents, boundaryEventExecutions);
            }
        } else {
            throw new FlowableException("Expected an activity behavior in flow node " + flowNode.getId() + " for " + String.valueOf(this.execution));
        }
    }

    protected boolean hasMultiInstanceRootExecution(ExecutionEntity execution, FlowNode flowNode) {
        for (ExecutionEntity currentExecution = execution.getParent(); currentExecution != null; currentExecution = currentExecution.getParent()) {
            if (!currentExecution.isMultiInstanceRoot() || !flowNode.getId().equals(currentExecution.getActivityId())) continue;
            return true;
        }
        return false;
    }

    protected ExecutionEntity createMultiInstanceRootExecution(ExecutionEntity execution) {
        ExecutionEntity parentExecution = execution.getParent();
        FlowElement flowElement = execution.getCurrentFlowElement();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        executionEntityManager.deleteRelatedDataForExecution(execution, null, false);
        executionEntityManager.delete(execution);
        ExecutionEntity multiInstanceRootExecution = executionEntityManager.createChildExecution(parentExecution);
        multiInstanceRootExecution.setCurrentFlowElement(flowElement);
        multiInstanceRootExecution.setMultiInstanceRoot(true);
        multiInstanceRootExecution.setActive(false);
        return multiInstanceRootExecution;
    }

    protected void executeActivityBehavior(ActivityBehavior activityBehavior, FlowNode flowNode) {
        LOGGER.debug("Executing activityBehavior {} on activity '{}' with execution {}", new Object[]{activityBehavior.getClass(), flowNode.getId(), this.execution.getId()});
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = null;
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            if (flowNode instanceof Activity && ((Activity)flowNode).hasMultiInstanceLoopCharacteristics()) {
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMultiInstanceActivityEvent(FlowableEngineEventType.MULTI_INSTANCE_ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode), processEngineConfiguration.getEngineCfgKey());
            } else {
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode), processEngineConfiguration.getEngineCfgKey());
            }
        }
        if (processEngineConfiguration.isLoggingSessionEnabled()) {
            BpmnLoggingSessionUtil.addExecuteActivityBehaviorLoggingData("activityBehaviorExecute", activityBehavior, flowNode, this.execution);
        }
        try {
            if (this.migrationContext != null && activityBehavior instanceof ActivityWithMigrationContextBehavior) {
                ActivityWithMigrationContextBehavior activityWithMigrationContextBehavior = (ActivityWithMigrationContextBehavior)((Object)activityBehavior);
                activityWithMigrationContextBehavior.execute(this.execution, this.migrationContext);
            } else {
                activityBehavior.execute(this.execution);
            }
        }
        catch (RuntimeException e) {
            if (LogMDC.isMDCEnabled()) {
                LogMDC.putMDCExecution(this.execution);
            }
            throw e;
        }
    }

    protected void continueThroughSequenceFlow(SequenceFlow sequenceFlow) {
        if (CollectionUtil.isNotEmpty((Collection)sequenceFlow.getExecutionListeners())) {
            try {
                this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "start");
                this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "take");
                this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "end");
            }
            catch (BpmnError bpmnError) {
                ErrorPropagation.propagateError(bpmnError, (DelegateExecution)this.execution);
                return;
            }
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = null;
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
            FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSequenceFlowTakenEvent(this.execution, FlowableEngineEventType.SEQUENCEFLOW_TAKEN, sequenceFlow.getId(), sourceFlowElement != null ? sourceFlowElement.getId() : null, sourceFlowElement != null ? sourceFlowElement.getName() : null, sourceFlowElement != null ? sourceFlowElement.getClass().getName() : null, sourceFlowElement != null ? ((FlowNode)sourceFlowElement).getBehavior() : null, targetFlowElement != null ? targetFlowElement.getId() : null, targetFlowElement != null ? targetFlowElement.getName() : null, targetFlowElement != null ? targetFlowElement.getClass().getName() : null, targetFlowElement != null ? ((FlowNode)targetFlowElement).getBehavior() : null), processEngineConfiguration.getEngineCfgKey());
        }
        CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordSequenceFlowTaken(this.execution);
        FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
        this.execution.setCurrentFlowElement(targetFlowElement);
        LOGGER.debug("Sequence flow '{}' encountered. Continuing process by following it using execution {}", (Object)sequenceFlow.getId(), (Object)this.execution.getId());
        this.execution.setActive(targetFlowElement instanceof FlowNode);
        this.agenda.planContinueProcessOperation(this.execution);
    }

    protected List<ExecutionEntity> createBoundaryEvents(List<BoundaryEvent> boundaryEvents, ExecutionEntity execution) {
        ArrayList<ExecutionEntity> boundaryEventExecutions = new ArrayList<ExecutionEntity>(boundaryEvents.size());
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (!(boundaryEvent.getBehavior() instanceof BoundaryEventRegistryEventActivityBehavior) && (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
            ExecutionEntity childExecutionEntity = CommandContextUtil.getExecutionEntityManager(this.commandContext).createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
            childExecutionEntity.setScope(false);
            boundaryEventExecutions.add(childExecutionEntity);
            CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordActivityStart(childExecutionEntity);
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
            if (!processEngineConfiguration.isLoggingSessionEnabled()) continue;
            BpmnLoggingSessionUtil.addLoggingData(BpmnLoggingSessionUtil.getBoundaryCreateEventType(boundaryEvent), "Creating boundary event (" + BpmnLoggingSessionUtil.getBoundaryEventType(boundaryEvent) + ") for execution id " + childExecutionEntity.getId(), childExecutionEntity);
        }
        return boundaryEventExecutions;
    }

    protected void executeBoundaryEvents(List<BoundaryEvent> boundaryEvents, List<ExecutionEntity> boundaryEventExecutions) {
        if (!CollectionUtil.isEmpty(boundaryEventExecutions)) {
            Iterator<BoundaryEvent> boundaryEventsIterator = boundaryEvents.iterator();
            Iterator<ExecutionEntity> boundaryEventExecutionsIterator = boundaryEventExecutions.iterator();
            while (boundaryEventsIterator.hasNext() && boundaryEventExecutionsIterator.hasNext()) {
                BoundaryEvent boundaryEvent = boundaryEventsIterator.next();
                ExecutionEntity boundaryEventExecution = boundaryEventExecutionsIterator.next();
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                LOGGER.debug("Executing boundary event activityBehavior {} with execution {}", boundaryEventBehavior.getClass(), (Object)boundaryEventExecution.getId());
                boundaryEventBehavior.execute(boundaryEventExecution);
            }
        }
    }
}

