/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.v1.LegacyValidateController;
import org.apereo.cas.web.v2.ServiceValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Endpoint(id="casValidate", defaultAccess=Access.NONE)
public class CasProtocolValidationEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ServiceValidateConfigurationContext configurationContext;

    public CasProtocolValidationEndpoint(CasConfigurationProperties casProperties, ServiceValidateConfigurationContext configurationContext) {
        super(casProperties, configurationContext.getApplicationContext());
        this.configurationContext = configurationContext;
    }

    @PostMapping(value={"/validate"}, produces={"text/xml", "application/json"}, consumes={"text/plain", "application/x-www-form-urlencoded"})
    @Operation(summary="Produce a ticket validation response based on CAS Protocol v1", parameters={@Parameter(name="username", required=true, description="The username"), @Parameter(name="password", required=false, description="The password"), @Parameter(name="service", required=true, description="The service")})
    public ModelAndView validate(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.renderValidationView(request, response, LegacyValidateController.class);
    }

    @PostMapping(value={"/serviceValidate"}, produces={"text/xml", "application/json"}, consumes={"text/plain", "application/x-www-form-urlencoded"})
    @Operation(summary="Produce a ticket validation response based on CAS Protocol v2", parameters={@Parameter(name="username", required=true, description="The username"), @Parameter(name="password", required=false, description="The password"), @Parameter(name="service", required=true, description="The service")})
    public ModelAndView serviceValidate(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.renderValidationView(request, response, ServiceValidateController.class);
    }

    @PostMapping(value={"/p3/serviceValidate"}, produces={"application/xml", "application/json"}, consumes={"application/xml", "application/x-www-form-urlencoded"})
    @Operation(summary="Produce a ticket validation response based on CAS Protocol v3", parameters={@Parameter(name="username", required=true, description="The username"), @Parameter(name="password", required=false, description="The password"), @Parameter(name="service", required=true, description="The service")})
    public ModelAndView p3ServiceValidate(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.renderValidationView(request, response, V3ServiceValidateController.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView renderValidationView(HttpServletRequest request, HttpServletResponse response, Class viewClass) throws Throwable {
        WebApplicationService selectedService = (WebApplicationService)this.configurationContext.getServiceFactory().createService(request, WebApplicationService.class);
        Assert.notNull((Object)selectedService, (String)"Service is missing and must be specified");
        RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy((Service)selectedService);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
        ModelAndView modelAndView = this.configurationContext.getValidationViewFactory().getModelAndView(request, true, selectedService, viewClass);
        Authentication authentication = this.buildAuthentication(request, selectedService);
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).applicationContext((ApplicationContext)this.configurationContext.getApplicationContext()).service((Service)selectedService).principal(authentication.getPrincipal()).build();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(context);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((ApplicationContext)this.configurationContext.getApplicationContext(), (Principal)authentication.getPrincipal(), (PrincipalFactory)this.configurationContext.getPrincipalFactory(), (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
        Authentication finalAuthentication = builder.build();
        Assertion assertion = DefaultAssertionBuilder.builder().primaryAuthentication(finalAuthentication).service((Service)selectedService).authentications(CollectionUtils.wrap((Object)finalAuthentication)).registeredService(registeredService).build().assemble();
        modelAndView.addObject("assertion", (Object)assertion);
        modelAndView.addObject("service", (Object)selectedService);
        modelAndView.addObject("registeredService", (Object)registeredService);
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        try {
            Objects.requireNonNull(modelAndView.getView()).render(modelAndView.getModel(), (HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper);
        }
        finally {
            byte[] responseArray = responseWrapper.getContentAsByteArray();
            String output = new String(responseArray, responseWrapper.getCharacterEncoding());
            modelAndView.addObject("response", (Object)output);
            modelAndView.setView((View)new MappingJackson2JsonView());
            modelAndView.setStatus((HttpStatusCode)HttpStatus.OK);
        }
        return modelAndView;
    }

    protected Authentication buildAuthentication(HttpServletRequest request, WebApplicationService selectedService) throws Throwable {
        String password = request.getParameter("password");
        String username = FunctionUtils.throwIfBlank((String)request.getParameter("username"));
        if (StringUtils.isNotBlank((CharSequence)password)) {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
            AuthenticationResult result = this.configurationContext.getAuthenticationSystemSupport().finalizeAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
            return result.getAuthentication();
        }
        Principal principal = this.configurationContext.getPrincipalResolver().resolve((Credential)new BasicIdentifiableCredential(username), Optional.of(this.configurationContext.getPrincipalFactory().createPrincipal(username)), Optional.empty(), Optional.of(selectedService));
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
    }
}

