/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record OidcIdTokenExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<OAuth20AccessToken>
{
    private static final long serialVersionUID = -3597980180617072826L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        Duration timeout = Beans.newDuration((String)this.casProperties.getAuthn().getOidc().getIdToken().getMaxTimeToLiveInSeconds());
        return new HardTimeoutExpirationPolicy(timeout.toSeconds());
    }
}

