/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.Action;

public abstract class AbstractCasMultifactorWebflowConfigurer
extends AbstractCasWebflowConfigurer
implements CasMultifactorWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasMultifactorWebflowConfigurer.class);
    private static final String LOG_MESSAGE_TRANSITION_ID = "Locating transition id [{}] to process multifactor authentication for state [{}]...";
    protected final List<FlowDefinitionRegistry> multifactorAuthenticationFlowDefinitionRegistries = new ArrayList<FlowDefinitionRegistry>();
    private final List<CasMultifactorWebflowCustomizer> multifactorAuthenticationFlowCustomizers = new ArrayList<CasMultifactorWebflowCustomizer>();

    protected AbstractCasMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, Optional<FlowDefinitionRegistry> mfaFlowDefinitionRegistry, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        this(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, mfaFlowDefinitionRegistry.map(List::of).orElseGet(List::of), mfaFlowCustomizers);
    }

    private AbstractCasMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<FlowDefinitionRegistry> mfaFlowDefinitionRegistry, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
        this.multifactorAuthenticationFlowDefinitionRegistries.addAll(mfaFlowDefinitionRegistry);
        this.multifactorAuthenticationFlowCustomizers.addAll(mfaFlowCustomizers);
    }

    @Override
    public void registerMultifactorProviderAuthenticationWebflow(Flow flow, String subflowId, String providerId) {
        if (flow == null) {
            LOGGER.error("Unable to locate parent flow definition to register provider [{}]", (Object)providerId);
            return;
        }
        this.multifactorAuthenticationFlowDefinitionRegistries.stream().filter(registry -> registry.containsFlowDefinition(subflowId)).forEach(registry -> {
            Flow mfaFlow = (Flow)registry.getFlowDefinition(subflowId);
            mfaFlow.getStartActionList().add((Action)new ConsumerExecutionAction(WebUtils::createCredential));
            SetAction setCredential = this.createSetAction("flowScope.".concat("mfaProviderId"), StringUtils.quote((String)providerId));
            mfaFlow.getStartActionList().add((Action)setCredential);
            TransitionableState initStartState = (TransitionableState)mfaFlow.getStartState();
            Transition transition = (Transition)initStartState.getTransition("success");
            String targetStateId = transition.getTargetStateId();
            transition.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("mfaCheckBypass"));
            this.registerMultifactorProviderBypassAction(mfaFlow);
            this.registerMultifactorProviderAvailableAction(mfaFlow, targetStateId);
            this.registerMultifactorProviderFailureAction(flow, mfaFlow);
            SubflowState subflowState = this.createSubflowState(flow, subflowId, subflowId);
            List subflowMappings = Stream.of("service", "registeredService").map(attr -> new DefaultMapping(this.createExpression("flowScope." + attr), this.createExpression((String)attr))).collect(Collectors.toList());
            subflowMappings.add(new DefaultMapping(this.createExpression("flowScope.credential"), this.createExpression("parent" + StringUtils.capitalize((String)"credential"))));
            this.multifactorAuthenticationFlowCustomizers.forEach(c -> c.getWebflowAttributeMappings().forEach(key -> subflowMappings.add(new DefaultMapping(this.createExpression("flowScope." + key), this.createExpression((String)key)))));
            Mapper inputMapper = this.createFlowInputMapper(subflowMappings);
            SubflowAttributeMapper subflowMapper = this.createSubflowAttributeMapper(inputMapper, null);
            subflowState.setAttributeMapper(subflowMapper);
            List flowMappings = Stream.of("service", "registeredService").map(attr -> new DefaultMapping(this.createExpression((String)attr), this.createExpression("flowScope." + attr))).collect(Collectors.toList());
            flowMappings.add(new DefaultMapping(this.createExpression("parent" + StringUtils.capitalize((String)"credential")), this.createExpression("flowScope.parent" + StringUtils.capitalize((String)"credential"))));
            this.multifactorAuthenticationFlowCustomizers.forEach(c -> c.getWebflowAttributeMappings().forEach(key -> flowMappings.add(new DefaultMapping(this.createExpression((String)key), this.createExpression("flowScope." + key)))));
            this.createFlowInputMapper(flowMappings, mfaFlow);
            Collection<String> states = this.getCandidateStatesForMultifactorAuthentication();
            this.registerMultifactorAuthenticationSubflowWithStates(flow, subflowState, states);
            this.registerMultifactorFlowDefinitionIntoLoginFlowRegistry();
            this.augmentMultifactorProviderFlowRegistry();
            LOGGER.trace("Registering the [{}] flow into the flow [{}]", (Object)subflowId, (Object)flow.getId());
            TransitionableState startState = flow.getTransitionableState(flow.getStartState().getId());
            this.createTransitionForState(startState, subflowId, subflowId, true);
            TransitionableState initState = this.getState(flow, "initialAuthenticationRequestValidationCheck");
            this.createTransitionForState(initState, subflowId, subflowId, true);
        });
    }

    private Collection<String> getCandidateStatesForMultifactorAuthentication() {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        candidates.add("realSubmit");
        this.multifactorAuthenticationFlowCustomizers.forEach(c -> candidates.addAll(c.getCandidateStatesForMultifactorAuthentication()));
        return candidates;
    }

    private void registerMultifactorFlowDefinitionIntoLoginFlowRegistry() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            String[] flowIds;
            for (String flowId : flowIds = registry.getFlowDefinitionIds()) {
                FlowDefinition definition = registry.getFlowDefinition(flowId);
                if (definition == null) continue;
                LOGGER.trace("Registering flow definition [{}]", (Object)flowId);
                this.mainFlowDefinitionRegistry.registerFlowDefinition(definition);
            }
        });
    }

    private void ensureEndStateTransitionExists(TransitionableState state, Flow mfaProviderFlow, String transId, String stateId) {
        if (!this.containsTransition(state, transId)) {
            this.createTransitionForState(state, transId, stateId);
            if (!this.containsFlowState(mfaProviderFlow, stateId)) {
                this.createEndState(mfaProviderFlow, stateId);
            }
        }
    }

    private void augmentMultifactorProviderFlowRegistry() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            String[] flowIds = registry.getFlowDefinitionIds();
            Arrays.stream(flowIds).forEach(id -> {
                Flow flow = (Flow)registry.getFlowDefinition(id);
                if (flow != null && this.containsFlowState(flow, "realSubmit")) {
                    Collection<String> states = this.getCandidateStatesForMultifactorAuthentication();
                    states.forEach(s -> {
                        TransitionableState state = this.getState(flow, (String)s);
                        if (state != null) {
                            this.ensureEndStateTransitionExists(state, flow, "success", "success");
                            this.ensureEndStateTransitionExists(state, flow, "successWithWarnings", "successWithWarnings");
                            this.ensureEndStateTransitionExists(state, flow, "unavailable", "mfaUnavailable");
                            this.ensureEndStateTransitionExists(state, flow, "deny", "mfaDenied");
                        } else {
                            LOGGER.debug("Unable to locate state definition [{}] in flow [{}]", s, (Object)flow.getId());
                        }
                    });
                }
            });
        });
    }

    private void registerMultifactorAuthenticationSubflowWithStates(Flow flow, SubflowState subflowState, Collection<String> states) {
        String subflowId = subflowState.getId();
        LOGGER.trace("Candidate states for multifactor authentication are [{}]", states);
        states.forEach(stateId -> {
            LOGGER.trace("Locating state [{}] to process for multifactor authentication", stateId);
            TransitionableState actionState = this.getState(flow, (String)stateId);
            if (actionState == null) {
                LOGGER.error("Unable to locate state definition [{}] in flow [{}]", stateId, (Object)flow.getId());
            } else {
                LOGGER.trace("Adding transition [{}] to [{}] for [{}]", new Object[]{"deny", "mfaDenied", stateId});
                this.createTransitionForState(actionState, "deny", "mfaDenied");
                LOGGER.trace("Adding transition [{}] to [{}] for [{}]", new Object[]{"unavailable", "mfaUnavailable", stateId});
                this.createTransitionForState(actionState, "unavailable", "mfaUnavailable");
                LOGGER.trace(LOG_MESSAGE_TRANSITION_ID, (Object)"success", stateId);
                String targetSuccessId = actionState.getTransition("success").getTargetStateId();
                LOGGER.trace(LOG_MESSAGE_TRANSITION_ID, (Object)"successWithWarnings", stateId);
                String targetWarningsId = actionState.getTransition("successWithWarnings").getTargetStateId();
                LOGGER.trace(LOG_MESSAGE_TRANSITION_ID, (Object)"deny", stateId);
                String targetDenied = actionState.getTransition("deny").getTargetStateId();
                LOGGER.trace("Location transition id [{}] to process multifactor authentication for state [{}]", (Object)"unavailable", stateId);
                String targetUnavailable = actionState.getTransition("unavailable").getTargetStateId();
                LOGGER.trace("Creating transitions to subflow state [{}]", (Object)subflowState.getId());
                TransitionSet transitionSet = subflowState.getTransitionSet();
                transitionSet.add(this.createTransition("success", targetSuccessId));
                transitionSet.add(this.createTransition("successWithWarnings", targetWarningsId));
                transitionSet.add(this.createTransition("deny", targetDenied));
                transitionSet.add(this.createTransition("mfaDenied", targetDenied));
                transitionSet.add(this.createTransition("unavailable", targetUnavailable));
                transitionSet.add(this.createTransition("mfaUnavailable", targetUnavailable));
                transitionSet.add(this.createTransition("cancel", "initializeLoginForm"));
                LOGGER.trace("Creating transition [{}] for state [{}]", (Object)subflowId, (Object)actionState.getId());
                this.createTransitionForState(actionState, subflowId, subflowId);
            }
        });
    }

    private void registerMultifactorProviderFailureAction(Flow flow, Flow mfaFlow) {
        if (flow != null) {
            ActionState failureAction = this.createActionState(mfaFlow, "mfaFailure", new String[]{"mfaFailureAction"});
            this.createTransitionForState((TransitionableState)failureAction, "unavailable", "mfaUnavailable");
            this.createTransitionForState((TransitionableState)failureAction, "bypass", "success");
            LOGGER.trace("Adding end state [{}] with transition to flow [{}] for MFA", (Object)"mfaUnavailable", (Object)flow.getId());
            this.createEndState(flow, "mfaUnavailable", "mfa/casMfaUnavailableView");
            LOGGER.trace("Adding end state [{}] with transition flow [{}] for MFA", (Object)"mfaDenied", (Object)flow.getId());
            this.createEndState(flow, "mfaDenied", "mfa/casMfaDeniedView");
        }
    }

    private void registerMultifactorProviderAvailableAction(Flow mfaFlow, String targetStateId) {
        ActionState availableAction = this.createActionState(mfaFlow, "mfaCheckAvailable", new String[]{"mfaAvailableAction"});
        if (mfaFlow.containsState("mfaPreAuth")) {
            this.createTransitionForState((TransitionableState)availableAction, "yes", "mfaPreAuth");
        } else {
            this.createTransitionForState((TransitionableState)availableAction, "yes", targetStateId);
        }
        this.createTransitionForState((TransitionableState)availableAction, "no", "mfaFailure");
    }

    private void registerMultifactorProviderBypassAction(Flow mfaFlow) {
        ActionState bypassAction = this.createActionState(mfaFlow, "mfaCheckBypass", new String[]{"mfaBypassAction"});
        this.createTransitionForState((TransitionableState)bypassAction, "no", "mfaCheckAvailable");
        this.createTransitionForState((TransitionableState)bypassAction, "yes", "success");
    }

    @Override
    @Generated
    public List<FlowDefinitionRegistry> getMultifactorAuthenticationFlowDefinitionRegistries() {
        return this.multifactorAuthenticationFlowDefinitionRegistries;
    }

    @Generated
    public List<CasMultifactorWebflowCustomizer> getMultifactorAuthenticationFlowCustomizers() {
        return this.multifactorAuthenticationFlowCustomizers;
    }
}

