/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ldaptive.beans.reflect.ReflectionTranscoder;
import org.ldaptive.beans.reflect.SingleValueReflectionTranscoder;

public class ArrayReflectionTranscoder
implements ReflectionTranscoder {
    private final SingleValueReflectionTranscoder<?> valueTranscoder;
    private final Class<?> type;

    public ArrayReflectionTranscoder(SingleValueReflectionTranscoder<?> transcoder) {
        this.valueTranscoder = transcoder;
        this.type = Array.newInstance(this.valueTranscoder.getType(), 0).getClass();
    }

    @Override
    public Object decodeStringValues(Collection<String> values) {
        Object decoded = Array.newInstance(this.valueTranscoder.getType(), values.size());
        Iterator<String> iter = values.iterator();
        for (int i = 0; i < values.size(); ++i) {
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(iter.next());
            Array.set(decoded, i, this.valueTranscoder.decodeStringValues(l));
        }
        return decoded;
    }

    @Override
    public Object decodeBinaryValues(Collection<byte[]> values) {
        Object decoded = Array.newInstance(this.valueTranscoder.getType(), values.size());
        Iterator<byte[]> iter = values.iterator();
        for (int i = 0; i < values.size(); ++i) {
            ArrayList<byte[]> l = new ArrayList<byte[]>(1);
            l.add(iter.next());
            Array.set(decoded, i, this.valueTranscoder.decodeBinaryValues(l));
        }
        return decoded;
    }

    @Override
    public Collection<String> encodeStringValues(Object values) {
        ArrayList<String> encoded = new ArrayList<String>();
        if (values instanceof Object[]) {
            for (Object o : (Object[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(o));
            }
        } else if (values instanceof boolean[]) {
            for (boolean o : (boolean[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(o));
            }
        } else if (values instanceof double[]) {
            for (double o : (double[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(o));
            }
        } else if (values instanceof float[]) {
            for (float o : (float[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(Float.valueOf(o)));
            }
        } else if (values instanceof int[]) {
            for (int o : (int[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(o));
            }
        } else if (values instanceof long[]) {
            for (long o : (long[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(o));
            }
        } else if (values instanceof short[]) {
            for (short o : (short[])values) {
                encoded.addAll(this.valueTranscoder.encodeStringValues(o));
            }
        } else {
            throw new IllegalArgumentException("Unsupported array type: " + values);
        }
        return encoded;
    }

    @Override
    public Collection<byte[]> encodeBinaryValues(Object values) {
        ArrayList<byte[]> encoded = new ArrayList<byte[]>();
        if (values instanceof Object[]) {
            for (Object o : (Object[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(o));
            }
        } else if (values instanceof boolean[]) {
            for (boolean o : (boolean[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(o));
            }
        } else if (values instanceof double[]) {
            for (double o : (double[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(o));
            }
        } else if (values instanceof float[]) {
            for (float o : (float[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(Float.valueOf(o)));
            }
        } else if (values instanceof int[]) {
            for (int o : (int[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(o));
            }
        } else if (values instanceof long[]) {
            for (long o : (long[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(o));
            }
        } else if (values instanceof short[]) {
            for (short o : (short[])values) {
                encoded.addAll(this.valueTranscoder.encodeBinaryValues(o));
            }
        } else {
            throw new IllegalArgumentException("Unsupported array type: " + values);
        }
        return encoded;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean supports(Class<?> t) {
        return this.getType().equals(t);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "valueTranscoder=" + this.valueTranscoder + "]";
    }
}

