/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPARelationshipType;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAARelationship;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAURelationship;

public class JPARelationshipTypeDAO
extends AbstractDAO<RelationshipType>
implements RelationshipTypeDAO {
    public RelationshipType find(String key) {
        return (RelationshipType)this.entityManager().find(JPARelationshipType.class, (Object)key);
    }

    public List<RelationshipType> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARelationshipType.class.getSimpleName() + " e ", RelationshipType.class);
        return query.getResultList();
    }

    public RelationshipType save(RelationshipType anyType) {
        return (RelationshipType)this.entityManager().merge((Object)anyType);
    }

    private Collection<? extends Relationship<?, ?>> findRelationshipsByType(RelationshipType type) {
        TypedQuery aquery = this.entityManager().createQuery("SELECT e FROM " + JPAARelationship.class.getSimpleName() + " e WHERE e.type=:type", ARelationship.class);
        aquery.setParameter("type", (Object)type);
        TypedQuery uquery = this.entityManager().createQuery("SELECT e FROM " + JPAURelationship.class.getSimpleName() + " e WHERE e.type=:type", URelationship.class);
        uquery.setParameter("type", (Object)type);
        ArrayList result = new ArrayList();
        result.addAll(aquery.getResultList());
        result.addAll(uquery.getResultList());
        return result;
    }

    public void delete(String key) {
        RelationshipType type = this.find(key);
        if (type == null) {
            return;
        }
        this.findRelationshipsByType(type).stream().map(relationship -> {
            if (relationship instanceof URelationship) {
                ((User)((URelationship)relationship).getLeftEnd()).getRelationships().remove((URelationship)relationship);
            } else if (relationship instanceof UMembership) {
                ((User)((UMembership)relationship).getLeftEnd()).remove((Membership)((UMembership)relationship));
            } else if (relationship instanceof ARelationship) {
                ((AnyObject)((ARelationship)relationship).getLeftEnd()).getRelationships().remove((ARelationship)relationship);
            } else if (relationship instanceof AMembership) {
                ((AnyObject)((AMembership)relationship).getLeftEnd()).remove((Membership)((AMembership)relationship));
            }
            relationship.setLeftEnd(null);
            return relationship;
        }).forEach(arg_0 -> ((EntityManager)this.entityManager()).remove(arg_0));
        this.entityManager().remove((Object)type);
    }
}

