/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public class JPARealmDAO
extends AbstractDAO<Realm>
implements RealmDAO {
    protected final RoleDAO roleDAO;
    protected final ApplicationEventPublisher publisher;

    protected static int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected static StringBuilder buildDescendantsQuery(Set<String> bases, String keyword, List<Object> parameters) {
        String basesClause = bases.stream().map(base -> "e.fullPath=?" + JPARealmDAO.setParameter(parameters, base) + " OR e.fullPath LIKE ?" + JPARealmDAO.setParameter(parameters, "/".equals(base) ? "/%" : base + "/%")).collect(Collectors.joining(" OR "));
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPARealm.class.getSimpleName()).append(" e ").append("WHERE (").append(basesClause).append(')');
        if (keyword != null) {
            queryString.append(" AND LOWER(e.name) LIKE ?").append(JPARealmDAO.setParameter(parameters, "%" + keyword.replaceAll("_", "\\\\_").toLowerCase() + "%"));
        }
        return queryString;
    }

    public JPARealmDAO(RoleDAO roleDAO, ApplicationEventPublisher publisher) {
        this.roleDAO = roleDAO;
        this.publisher = publisher;
    }

    public Realm getRoot() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.parent IS NULL", Realm.class);
        Realm result = null;
        try {
            result = (Realm)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("Root realm not found", (Throwable)e);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Realm find(String key) {
        return (Realm)this.entityManager().find(JPARealm.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public Realm findByFullPath(String fullPath) {
        if ("/".equals(fullPath)) {
            return this.getRoot();
        }
        if (StringUtils.isBlank((CharSequence)fullPath) || !PATH_PATTERN.matcher(fullPath).matches()) {
            throw new MalformedPathException(fullPath);
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.fullPath=:fullPath", Realm.class);
        query.setParameter("fullPath", (Object)fullPath);
        Realm result = null;
        try {
            result = (Realm)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("Root realm not found", (Throwable)e);
        }
        return result;
    }

    public List<Realm> findByName(String name) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.name=:name", Realm.class);
        query.setParameter("name", (Object)name);
        return query.getResultList();
    }

    public List<Realm> findByResource(ExternalResource resource) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE :resource MEMBER OF e.resources", Realm.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public int countDescendants(String base, String keyword) {
        return this.countDescendants(Set.of(base), keyword);
    }

    public int countDescendants(Set<String> bases, String keyword) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = JPARealmDAO.buildDescendantsQuery(bases, keyword, parameters);
        Query query = this.entityManager().createQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)"SELECT e ", (String)"SELECT COUNT(e) "));
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    public List<Realm> findDescendants(String base, String keyword, int page, int itemsPerPage) {
        return this.findDescendants(Set.of(base), keyword, page, itemsPerPage);
    }

    public List<Realm> findDescendants(Set<String> bases, String keyword, int page, int itemsPerPage) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = JPARealmDAO.buildDescendantsQuery(bases, keyword, parameters);
        TypedQuery query = this.entityManager().createQuery(queryString.append(" ORDER BY e.fullPath").toString(), Realm.class);
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    public List<String> findDescendants(String base, String prefix) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = JPARealmDAO.buildDescendantsQuery(Set.of(base), null, parameters);
        TypedQuery query = this.entityManager().createQuery(queryString.append(" AND (e.fullPath=?").append(JPARealmDAO.setParameter(parameters, prefix)).append(" OR e.fullPath LIKE ?").append(JPARealmDAO.setParameter(parameters, "/".equals(prefix) ? "/%" : prefix + "/%")).append(')').append(" ORDER BY e.fullPath").toString(), Realm.class);
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        return query.getResultList().stream().map(Entity::getKey).collect(Collectors.toList());
    }

    protected <T extends Policy> List<Realm> findSamePolicyChildren(Realm realm, T policy) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        this.findChildren(realm).stream().filter(child -> policy instanceof AccountPolicy && child.getAccountPolicy() == null || policy.equals(child.getAccountPolicy()) || policy instanceof PasswordPolicy && child.getPasswordPolicy() == null || policy.equals(child.getPasswordPolicy())).forEach(child -> {
            result.add((Realm)child);
            result.addAll(this.findSamePolicyChildren((Realm)child, policy));
        });
        return result;
    }

    public <T extends Policy> List<Realm> findByPolicy(T policy) {
        if (policy instanceof PropagationPolicy || policy instanceof ProvisioningPolicy) {
            return List.of();
        }
        String policyColumn = null;
        if (policy instanceof AccountPolicy) {
            policyColumn = "accountPolicy";
        } else if (policy instanceof PasswordPolicy) {
            policyColumn = "passwordPolicy";
        } else if (policy instanceof AuthPolicy) {
            policyColumn = "authPolicy";
        } else if (policy instanceof AccessPolicy) {
            policyColumn = "accessPolicy";
        } else if (policy instanceof AttrReleasePolicy) {
            policyColumn = "attrReleasePolicy";
        } else if (policy instanceof TicketExpirationPolicy) {
            policyColumn = "ticketExpirationPolicy";
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e." + policyColumn + "=:policy", Realm.class);
        query.setParameter("policy", policy);
        ArrayList<Realm> result = new ArrayList<Realm>();
        query.getResultList().forEach(realm -> {
            result.add((Realm)realm);
            result.addAll(this.findSamePolicyChildren((Realm)realm, policy));
        });
        return result;
    }

    public List<Realm> findByLogicActions(Implementation logicActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE :logicActions MEMBER OF e.actions", Realm.class);
        query.setParameter("logicActions", (Object)logicActions);
        return query.getResultList();
    }

    protected void findAncestors(List<Realm> result, Realm realm) {
        if (realm.getParent() != null && !result.contains(realm.getParent())) {
            result.add(realm.getParent());
            this.findAncestors(result, realm.getParent());
        }
    }

    public List<Realm> findAncestors(Realm realm) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        result.add(realm);
        this.findAncestors(result, realm);
        return result;
    }

    public List<Realm> findChildren(Realm realm) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.parent=:realm", Realm.class);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }

    protected String buildFullPath(Realm realm) {
        return realm.getParent() == null ? "/" : StringUtils.appendIfMissing((String)realm.getParent().getFullPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + realm.getName();
    }

    public int count() {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(id) FROM Realm");
        return ((Number)query.getSingleResult()).intValue();
    }

    public List<String> findAllKeys(int page, int itemsPerPage) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM Realm ORDER BY fullPath");
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        List raw = query.getResultList();
        return raw.stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).collect(Collectors.toList());
    }

    public Realm save(Realm realm) {
        String fullPathBefore = realm.getFullPath();
        String fullPathAfter = this.buildFullPath(realm);
        if (!fullPathAfter.equals(fullPathBefore)) {
            ((JPARealm)realm).setFullPath(fullPathAfter);
        }
        Realm merged = (Realm)this.entityManager().merge((Object)realm);
        if (!fullPathAfter.equals(fullPathBefore)) {
            this.findChildren(realm).forEach(this::save);
        }
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)merged, AuthContextUtils.getDomain()));
        return merged;
    }

    public void delete(Realm realm) {
        if (realm == null || realm.getParent() == null) {
            return;
        }
        this.findDescendants(realm.getFullPath(), null, -1, -1).forEach(toBeDeleted -> {
            this.roleDAO.findByRealm(toBeDeleted).forEach(role -> role.getRealms().remove(toBeDeleted));
            toBeDeleted.setParent(null);
            this.entityManager().remove(toBeDeleted);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Entity)toBeDeleted, AuthContextUtils.getDomain()));
        });
    }
}

