/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowOutputMappingException;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public class EndState
extends State {
    private Action finalResponseAction;
    private Mapper outputMapper;

    public EndState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public void setFinalResponseAction(Action finalResponseAction) {
        this.finalResponseAction = finalResponseAction;
    }

    public void setOutputMapper(Mapper outputMapper) {
        this.outputMapper = outputMapper;
    }

    @Override
    protected void doEnter(RequestControlContext context) throws FlowExecutionException {
        FlowSession activeSession = context.getFlowExecutionContext().getActiveSession();
        if (activeSession.isRoot()) {
            if (this.finalResponseAction != null && !context.getExternalContext().isResponseComplete()) {
                ActionExecutor.execute(this.finalResponseAction, context);
                context.getExternalContext().recordResponseComplete();
            }
            context.endActiveFlowSession(this.getId(), this.createSessionOutput(context));
        } else {
            LocalAttributeMap<Object> sessionOutput = this.createSessionOutput(context);
            context.endActiveFlowSession(this.getId(), sessionOutput);
        }
    }

    protected LocalAttributeMap<Object> createSessionOutput(RequestContext context) {
        MappingResults results;
        LocalAttributeMap<Object> output = new LocalAttributeMap<Object>();
        if (this.outputMapper != null && (results = this.outputMapper.map((Object)context, output)) != null && results.hasErrorResults()) {
            throw new FlowOutputMappingException(this.getOwner().getId(), this.getId(), results);
        }
        return output;
    }

    @Override
    protected void appendToString(ToStringCreator creator) {
        creator.append("finalResponseAction", (Object)this.finalResponseAction).append("outputMapper", (Object)this.outputMapper);
    }
}

