/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ThreadPreferenceExecutor
implements Executor {
    private final int maxThreads;
    private final long idleTime;
    private final TimeUnit unit;
    private final ThreadFactory threadFactory;
    private final BlockingQueue<Runnable> queue;
    private final String name;
    private final Logger logger;
    private int numberOfActiveThreads = 0;
    private int newThreadCreateCount = 0;

    public ThreadPreferenceExecutor(String name, int maxThreads, long idleTime, TimeUnit unit, Logger logger) {
        this(name, maxThreads, idleTime, unit, ThreadPreferenceExecutor.defaultThreadFactory(name), logger);
    }

    private static ThreadFactory defaultThreadFactory(String name) {
        return new DefaultThreadFactory(name);
    }

    public ThreadPreferenceExecutor(String name, int maxThreads, long idleTime, TimeUnit unit, ThreadFactory threadFactory, Logger logger) {
        this.name = name;
        this.maxThreads = maxThreads;
        this.idleTime = idleTime;
        this.unit = unit;
        this.threadFactory = threadFactory;
        this.queue = new SynchronousQueue<Runnable>();
        this.logger = logger;
    }

    @Override
    public void execute(Runnable command) {
        if (this.queue.offer(command)) {
            return;
        }
        boolean accepted = this.createNewThreadIfPossible(command);
        if (!accepted) {
            throw new RejectedExecutionException("Max thread limit (" + this.maxThreads + ") reached for [" + this.getName() + "]");
        }
    }

    private String getName() {
        return this.name;
    }

    private synchronized boolean createNewThreadIfPossible(Runnable command) {
        if (this.numberOfActiveThreads == this.maxThreads) {
            return false;
        }
        ++this.numberOfActiveThreads;
        ++this.newThreadCreateCount;
        Thread newThread = this.threadFactory.newThread(new WorkerTask(command));
        newThread.start();
        if (this.newThreadCreateCount % 5 == 0) {
            this.newThreadCreateCount = 0;
            if (this.numberOfActiveThreads > this.maxThreads - 10) {
                this.logger.info(this.getName() + " thread count : " + this.numberOfActiveThreads);
            }
        }
        return true;
    }

    private synchronized void workerDone() {
        --this.numberOfActiveThreads;
    }

    public synchronized int getActiveThreadCount() {
        return this.numberOfActiveThreads;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger sequence = new AtomicInteger();
        private final String executorName;

        DefaultThreadFactory(String executorName) {
            this.executorName = executorName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.executorName + "-" + this.sequence.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(6);
            return t;
        }
    }

    private class WorkerTask
    implements Runnable {
        private Runnable firstCommand;

        WorkerTask(Runnable firstCommand) {
            this.firstCommand = firstCommand;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Runnable task;
                    if ((task = this.getTask()) == null) {
                        return;
                    }
                    task.run();
                }
            }
            finally {
                ThreadPreferenceExecutor.this.workerDone();
            }
        }

        private Runnable getTask() {
            Runnable task;
            if (this.firstCommand != null) {
                task = this.firstCommand;
                this.firstCommand = null;
            } else {
                try {
                    task = (Runnable)ThreadPreferenceExecutor.this.queue.poll(ThreadPreferenceExecutor.this.idleTime, ThreadPreferenceExecutor.this.unit);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return task;
        }
    }
}

