/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.util.Optional;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;

public final class ConnPoolConfUtils {
    public static ConnPoolConf getConnPoolConf(ConnPoolConfTO cpcto, ConnPoolConf cpc) {
        ObjectPoolConfiguration opc = new ObjectPoolConfiguration();
        cpc.setMaxIdle(Optional.ofNullable(cpcto.getMaxIdle()).orElse(opc.getMaxIdle()));
        cpc.setMaxObjects(Optional.ofNullable(cpcto.getMaxObjects()).orElse(opc.getMaxObjects()));
        cpc.setMaxWait(Optional.ofNullable(cpcto.getMaxWait()).orElse(opc.getMaxWait()));
        cpc.setMinEvictableIdleTimeMillis(Optional.ofNullable(cpcto.getMinEvictableIdleTimeMillis()).orElse(opc.getMinEvictableIdleTimeMillis()));
        cpc.setMinIdle(Optional.ofNullable(cpcto.getMinIdle()).orElse(opc.getMinIdle()));
        return cpc;
    }

    public static ObjectPoolConfiguration getObjectPoolConfiguration(ConnPoolConf cpc) {
        ObjectPoolConfiguration opc = new ObjectPoolConfiguration();
        ConnPoolConfUtils.updateObjectPoolConfiguration(opc, cpc);
        return opc;
    }

    public static void updateObjectPoolConfiguration(ObjectPoolConfiguration opc, ConnPoolConf cpc) {
        if (cpc.getMaxIdle() != null) {
            opc.setMaxIdle(cpc.getMaxIdle().intValue());
        }
        if (cpc.getMaxObjects() != null) {
            opc.setMaxObjects(cpc.getMaxObjects().intValue());
        }
        if (cpc.getMaxWait() != null) {
            opc.setMaxWait(cpc.getMaxWait().longValue());
        }
        if (cpc.getMinEvictableIdleTimeMillis() != null) {
            opc.setMinEvictableIdleTimeMillis(cpc.getMinEvictableIdleTimeMillis().longValue());
        }
        if (cpc.getMinIdle() != null) {
            opc.setMinIdle(cpc.getMinIdle().intValue());
        }
    }

    private ConnPoolConfUtils() {
    }
}

