/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;

public class OAuth20JwtBuilder
extends JwtBuilder {
    public OAuth20JwtBuilder(CipherExecutor defaultTokenCipherExecutor, ServicesManager servicesManager, RegisteredServiceCipherExecutor registeredServiceCipherExecutor, CasConfigurationProperties casProperties) {
        super(defaultTokenCipherExecutor, servicesManager, registeredServiceCipherExecutor, casProperties);
    }

    protected RegisteredService locateRegisteredService(String id) {
        RegisteredService service = super.locateRegisteredService(id);
        if (service == null) {
            service = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getServicesManager(), id);
        }
        return service;
    }
}

