/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.context.properties;

import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.context.properties.ConfigurationPropertiesReportEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.context.properties.ConfigurationPropertiesReportEndpoint;
import org.springframework.boot.actuate.context.properties.ConfigurationPropertiesReportEndpointWebExtension;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(endpoint=ConfigurationPropertiesReportEndpoint.class)
@EnableConfigurationProperties(value={ConfigurationPropertiesReportEndpointProperties.class})
public class ConfigurationPropertiesReportEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConfigurationPropertiesReportEndpoint configurationPropertiesReportEndpoint(ConfigurationPropertiesReportEndpointProperties properties, ObjectProvider<SanitizingFunction> sanitizingFunctions) {
        String[] additionalKeysToSanitize;
        ConfigurationPropertiesReportEndpoint endpoint = new ConfigurationPropertiesReportEndpoint((Iterable)sanitizingFunctions.orderedStream().collect(Collectors.toList()));
        String[] keysToSanitize = properties.getKeysToSanitize();
        if (keysToSanitize != null) {
            endpoint.setKeysToSanitize(keysToSanitize);
        }
        if ((additionalKeysToSanitize = properties.getAdditionalKeysToSanitize()) != null) {
            endpoint.keysToSanitize(additionalKeysToSanitize);
        }
        return endpoint;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ConfigurationPropertiesReportEndpoint.class})
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB, EndpointExposure.CLOUD_FOUNDRY})
    public ConfigurationPropertiesReportEndpointWebExtension configurationPropertiesReportEndpointWebExtension(ConfigurationPropertiesReportEndpoint configurationPropertiesReportEndpoint) {
        return new ConfigurationPropertiesReportEndpointWebExtension(configurationPropertiesReportEndpoint);
    }
}

