/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.QueryType;
import org.apereo.services.persondir.support.jdbc.AbstractJdbcPersonAttributeDao;
import org.apereo.services.persondir.support.jdbc.MultiRowJdbcPersonAttributeDao;
import org.apereo.services.persondir.support.jdbc.SingleRowJdbcPersonAttributeDao;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnClass(value={JpaBeans.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.PersonDirectory)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfiguration
public class CasPersonDirectoryJdbcConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryJdbcConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.jdbc[0].sql");

    @Configuration(value="JdbcAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JdbcAttributeRepositoryPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jdbcPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer jdbcPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="jdbcAttributeRepositories") BeanContainer<IPersonAttributeDao> jdbcAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = jdbcAttributeRepositories.toList().stream().filter(repo -> (Boolean)repo.getTags().get(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName())).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="JdbcAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JdbcAttributeRepositoryConfiguration {
        private static AbstractJdbcPersonAttributeDao configureJdbcPersonAttributeDao(AbstractJdbcPersonAttributeDao dao, JdbcPrincipalAttributesProperties jdbc) {
            List attributes = jdbc.getCaseInsensitiveQueryAttributes();
            Map results = CollectionUtils.convertDirectedListToMap((Collection)attributes);
            dao.setCaseInsensitiveQueryAttributes(results.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)(StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) ? CaseCanonicalizationMode.valueOf((String)jdbc.getCaseCanonicalization().toUpperCase()) : CaseCanonicalizationMode.valueOf((String)((String)entry.getValue()).toUpperCase())))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
            return dao;
        }

        private static AbstractJdbcPersonAttributeDao createJdbcPersonAttributeDao(JdbcPrincipalAttributesProperties jdbc) {
            String url = SpringExpressionLanguageValueResolver.getInstance().resolve(jdbc.getUrl());
            if (jdbc.isSingleRow()) {
                LOGGER.debug("Configured single-row JDBC attribute repository for [{}]", (Object)url);
                return JdbcAttributeRepositoryConfiguration.configureJdbcPersonAttributeDao((AbstractJdbcPersonAttributeDao)new SingleRowJdbcPersonAttributeDao((DataSource)JpaBeans.newDataSource((AbstractJpaProperties)jdbc), jdbc.getSql()), jdbc);
            }
            LOGGER.debug("Configured multi-row JDBC attribute repository for [{}]", (Object)url);
            MultiRowJdbcPersonAttributeDao jdbcDao = new MultiRowJdbcPersonAttributeDao((DataSource)JpaBeans.newDataSource((AbstractJpaProperties)jdbc), jdbc.getSql());
            LOGGER.debug("Configured multi-row JDBC column mappings for [{}] are [{}]", (Object)url, (Object)jdbc.getColumnMappings());
            jdbcDao.setNameValueColumnMappings(jdbc.getColumnMappings());
            return JdbcAttributeRepositoryConfiguration.configureJdbcPersonAttributeDao((AbstractJdbcPersonAttributeDao)jdbcDao, jdbc);
        }

        @ConditionalOnMissingBean(name={"jdbcAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<IPersonAttributeDao> jdbcAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ArrayList list = new ArrayList();
                PrincipalAttributesProperties attrs = casProperties.getAuthn().getAttributeRepository();
                attrs.getJdbc().stream().filter(jdbc -> StringUtils.isNotBlank((CharSequence)jdbc.getSql()) && StringUtils.isNotBlank((CharSequence)jdbc.getUrl())).forEach(jdbc -> {
                    AbstractJdbcPersonAttributeDao jdbcDao = JdbcAttributeRepositoryConfiguration.createJdbcPersonAttributeDao(jdbc);
                    FunctionUtils.doIfNotNull((Object)jdbc.getId(), xva$0 -> jdbcDao.setId(new String[]{xva$0}));
                    Map queryAttributes = CollectionUtils.wrap((String)"username", (Object)jdbc.getUsername());
                    queryAttributes.putAll(jdbc.getQueryAttributes());
                    jdbcDao.setQueryAttributeMapping(queryAttributes);
                    Map mapping = jdbc.getAttributes();
                    if (mapping != null && !mapping.isEmpty()) {
                        LOGGER.debug("Configured result attribute mapping for [{}] to be [{}]", (Object)jdbc.getUrl(), (Object)jdbc.getAttributes());
                        jdbcDao.setResultAttributeMapping(mapping);
                    }
                    jdbcDao.setRequireAllQueryAttributes(jdbc.isRequireAllAttributes());
                    CaseCanonicalizationMode caseMode = CaseCanonicalizationMode.valueOf((String)jdbc.getCaseCanonicalization().toUpperCase());
                    jdbcDao.setUsernameCaseCanonicalizationMode(caseMode);
                    jdbcDao.setDefaultCaseCanonicalizationMode(caseMode);
                    jdbcDao.setQueryType(QueryType.valueOf((String)jdbc.getQueryType().toUpperCase()));
                    jdbcDao.setOrder(jdbc.getOrder());
                    jdbcDao.setEnabled(jdbc.getState() != AttributeRepositoryStates.DISABLED);
                    jdbcDao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(jdbc.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                    list.add(jdbcDao);
                });
                return BeanContainer.of(list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

