/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.conditions;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.opensaml.saml.saml2.core.Conditions;

public class SamlProfileSamlConditionsBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Conditions> {
    private static final long serialVersionUID = 126393045912318783L;
    private final CasConfigurationProperties casProperties;

    public SamlProfileSamlConditionsBuilder(OpenSamlConfigBean configBean, CasConfigurationProperties casProperties) {
        super(configBean);
        this.casProperties = casProperties;
    }

    @Override
    public Conditions build(SamlProfileBuilderContext context) throws SamlException {
        return this.buildConditions(context);
    }

    protected Conditions buildConditions(SamlProfileBuilderContext context) throws SamlException {
        long skewAllowance;
        ZonedDateTime currentDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        long l = skewAllowance = context.getRegisteredService().getSkewAllowance() != 0 ? (long)context.getRegisteredService().getSkewAllowance() : Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance()).toSeconds();
        if (skewAllowance <= 0L) {
            skewAllowance = Beans.newDuration((String)this.casProperties.getSamlCore().getSkewAllowance()).toSeconds();
        }
        ArrayList<String> audienceUrls = new ArrayList<String>(2);
        audienceUrls.add(context.getAdaptor().getEntityId());
        if (StringUtils.isNotBlank((CharSequence)context.getRegisteredService().getAssertionAudiences())) {
            Set audiences = org.springframework.util.StringUtils.commaDelimitedListToSet((String)context.getRegisteredService().getAssertionAudiences());
            audienceUrls.addAll(audiences);
        }
        return this.newConditions(currentDateTime.minusSeconds(skewAllowance), currentDateTime.plusSeconds(skewAllowance), audienceUrls.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
    }
}

