/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class ChunkSampleSequenceStream
implements SequenceStream<ChunkSample> {
    private final ObjectStream<ChunkSample> samples;
    private final ChunkerContextGenerator contextGenerator;

    public ChunkSampleSequenceStream(ObjectStream<ChunkSample> samples, ChunkerContextGenerator generator) {
        this.samples = samples;
        this.contextGenerator = generator;
    }

    public Sequence<ChunkSample> read() throws IOException {
        ChunkSample sample = (ChunkSample)this.samples.read();
        if (sample != null) {
            String[] sentence = sample.getSentence();
            String[] tags = sample.getTags();
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                CharSequence[] context = this.contextGenerator.getContext(i, sentence, tags, null);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence(events, (Object)sample);
        }
        return null;
    }

    public Event[] updateContext(Sequence<ChunkSample> sequence, MaxentModel model) {
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
    }

    public void close() throws IOException {
        this.samples.close();
    }
}

