/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerStream;
import opennlp.tools.tokenize.WhitespaceTokenStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandLineTokenizer {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineTokenizer.class);
    private final Tokenizer tokenizer;

    CommandLineTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    void process() {
        PerformanceMonitor perfMon = new PerformanceMonitor("sent");
        try {
            String tokenizedLine;
            PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
            WhitespaceTokenStream tokenizedLineStream = new WhitespaceTokenStream((ObjectStream)new TokenizerStream(this.tokenizer, (ObjectStream)untokenizedLineStream));
            perfMon.start();
            while ((tokenizedLine = (String)tokenizedLineStream.read()) != null) {
                logger.info(tokenizedLine);
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

