/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.archive.io.GenericReplayCharSequence;
import org.archive.io.RecordingInputStream;
import org.archive.io.RecordingOutputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.io.ReplayInputStream;
import org.archive.util.ArchiveUtils;
import org.archive.util.ChunkedInputStream;
import org.archive.util.DevUtils;
import org.archive.util.FileUtils;

public class Recorder {
    protected static Logger logger = Logger.getLogger("org.archive.util.HttpRecorder");
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 16384;
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 524288;
    private RecordingInputStream ris = null;
    private RecordingOutputStream ros = null;
    private String backingFileBasename = null;
    private static final String RECORDING_OUTPUT_STREAM_SUFFIX = ".ros";
    private static final String RECORDING_INPUT_STREAM_SUFFIX = ".ris";
    protected String characterEncoding = null;
    protected Charset charset = StandardCharsets.UTF_8;
    protected boolean inputIsChunked = false;
    protected String contentEncoding = null;
    private ReplayCharSequence replayCharSequence;
    protected static ThreadLocal<Recorder> currentRecorder = new ThreadLocal();
    protected static Set<String> SUPPORTED_ENCODINGS = new HashSet<String>();

    public Recorder(File tempDir, String backingFilenameBase, int outBufferSize, int inBufferSize) {
        this(new File(Recorder.ensure(tempDir), backingFilenameBase), outBufferSize, inBufferSize);
    }

    private static File ensure(File tempDir) {
        try {
            FileUtils.ensureWriteableDirectory(tempDir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return tempDir;
    }

    public Recorder(File file, int outBufferSize, int inBufferSize) {
        this.backingFileBasename = file.getAbsolutePath();
        this.ris = new RecordingInputStream(inBufferSize, this.backingFileBasename + RECORDING_INPUT_STREAM_SUFFIX);
        this.ros = new RecordingOutputStream(outBufferSize, this.backingFileBasename + RECORDING_OUTPUT_STREAM_SUFFIX);
    }

    public Recorder(File tempDir, String backingFilenameBase) {
        this(tempDir, backingFilenameBase, 524288, 16384);
    }

    public InputStream inputWrap(InputStream is) throws IOException {
        logger.fine(Thread.currentThread().getName() + " wrapping input");
        this.characterEncoding = null;
        this.inputIsChunked = false;
        this.contentEncoding = null;
        this.ris.open(is);
        return this.ris;
    }

    public OutputStream outputWrap(OutputStream os) throws IOException {
        this.ros.open(os);
        return this.ros;
    }

    public void close() {
        logger.fine(Thread.currentThread().getName() + " closing");
        try {
            this.ris.close();
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, "close() ris" + DevUtils.extraInfo(), e);
        }
        try {
            this.ros.close();
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, "close() ros" + DevUtils.extraInfo(), e);
        }
    }

    public RecordingInputStream getRecordedInput() {
        return this.ris;
    }

    public RecordingOutputStream getRecordedOutput() {
        return this.ros;
    }

    public void markContentBegin() {
        this.ris.markContentBegin();
    }

    public long getResponseContentLength() {
        return this.ris.getResponseContentLength();
    }

    public void closeRecorders() {
        try {
            this.ris.closeRecorder();
            this.ros.closeRecorder();
        }
        catch (IOException e) {
            DevUtils.warnHandle(e, "Convert to runtime exception?");
        }
    }

    public void cleanup() {
        this.close();
        this.delete(this.backingFileBasename + RECORDING_OUTPUT_STREAM_SUFFIX);
        this.delete(this.backingFileBasename + RECORDING_INPUT_STREAM_SUFFIX);
    }

    private void delete(String name) {
        File f = new File(name);
        if (f.exists()) {
            f.delete();
        }
    }

    public static void setHttpRecorder(Recorder httpRecorder) {
        currentRecorder.set(httpRecorder);
    }

    public static Recorder getHttpRecorder() {
        return currentRecorder.get();
    }

    public void setCharset(Charset cs) {
        this.charset = cs;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setInputIsChunked(boolean chunked) {
        this.inputIsChunked = chunked;
    }

    public void setContentEncoding(String contentEncoding) {
        String lowerCoding = contentEncoding.toLowerCase(Locale.ROOT);
        if (!SUPPORTED_ENCODINGS.contains(contentEncoding.toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("contentEncoding unsupported: " + contentEncoding);
        }
        this.contentEncoding = lowerCoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public ReplayCharSequence getContentReplayCharSequence() throws IOException {
        if (this.replayCharSequence == null || !this.replayCharSequence.isOpen() || !this.replayCharSequence.getCharset().equals(this.charset)) {
            if (this.replayCharSequence != null && this.replayCharSequence.isOpen()) {
                this.replayCharSequence.close();
            }
            this.replayCharSequence = this.getContentReplayCharSequence(this.charset);
        }
        return this.replayCharSequence;
    }

    public ReplayCharSequence getContentReplayCharSequence(Charset requestedCharset) throws IOException {
        InputStream ris = this.getContentReplayInputStream();
        GenericReplayCharSequence rcs = new GenericReplayCharSequence(ris, Recorder.calcRecommendedCharBufferSize(this.getRecordedInput()), this.backingFileBasename + RECORDING_OUTPUT_STREAM_SUFFIX, requestedCharset);
        ris.close();
        return rcs;
    }

    protected static int calcRecommendedCharBufferSize(RecordingInputStream inStream) {
        return (int)Math.min((long)(inStream.getRecordedBufferLength() / 2), inStream.getSize());
    }

    public ReplayInputStream getReplayInputStream() throws IOException {
        return this.getRecordedInput().getReplayInputStream();
    }

    public ReplayInputStream getMessageBodyReplayInputStream() throws IOException {
        return this.getRecordedInput().getMessageBodyReplayInputStream();
    }

    public InputStream getEntityReplayInputStream() throws IOException {
        if (this.inputIsChunked) {
            return new ChunkedInputStream(this.getRecordedInput().getMessageBodyReplayInputStream());
        }
        return this.getRecordedInput().getMessageBodyReplayInputStream();
    }

    public InputStream getContentReplayInputStream() throws IOException {
        InputStream entityStream = this.getEntityReplayInputStream();
        if (StringUtils.isEmpty((CharSequence)this.contentEncoding)) {
            return entityStream;
        }
        if ("gzip".equalsIgnoreCase(this.contentEncoding) || "x-gzip".equalsIgnoreCase(this.contentEncoding)) {
            try {
                return new GZIPInputStream(entityStream);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "gzip problem; using raw entity instead", ioe);
                IOUtils.closeQuietly((InputStream)entityStream);
                return this.getEntityReplayInputStream();
            }
        }
        if ("deflate".equalsIgnoreCase(this.contentEncoding)) {
            return new DeflaterInputStream(entityStream);
        }
        if ("identity".equalsIgnoreCase(this.contentEncoding) || "none".equalsIgnoreCase(this.contentEncoding)) {
            return entityStream;
        }
        logger.log(Level.INFO, "Unknown content-encoding '" + this.contentEncoding + "' declared; using raw entity instead");
        return entityStream;
    }

    public String getContentReplayPrefixString(int size) {
        return this.getContentReplayPrefixString(size, this.charset);
    }

    public String getContentReplayPrefixString(int size, Charset cs) {
        try {
            InputStreamReader isr = new InputStreamReader(this.getContentReplayInputStream(), cs);
            char[] chars = new char[size];
            int count = isr.read(chars);
            isr.close();
            if (count > 0) {
                return new String(chars, 0, count);
            }
            return "";
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "unable to get replay prefix string", e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyContentBodyTo(File tempFile) throws IOException {
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = this.getContentReplayInputStream();
            outStream = org.apache.commons.io.FileUtils.openOutputStream((File)tempFile);
            IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
            IOUtils.closeQuietly((OutputStream)outStream);
        }
    }

    public static Recorder wrapInputStreamWithHttpRecord(File dir, String basename, InputStream in, String encoding) throws IOException {
        int x;
        Recorder rec = new Recorder(dir, basename);
        if (encoding != null && encoding.length() > 0) {
            rec.setCharset(Charset.forName(encoding));
        }
        InputStream is = rec.inputWrap(new BufferedInputStream(in));
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while ((x = is.read(buffer)) != -1) {
        }
        is.close();
        return rec;
    }

    public void endReplays() {
        ArchiveUtils.closeQuietly(this.replayCharSequence);
        this.replayCharSequence = null;
        try {
            this.ris.clearForReuse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.ros.clearForReuse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        SUPPORTED_ENCODINGS.add("gzip");
        SUPPORTED_ENCODINGS.add("x-gzip");
        SUPPORTED_ENCODINGS.add("deflate");
        SUPPORTED_ENCODINGS.add("identity");
        SUPPORTED_ENCODINGS.add("none");
    }
}

