/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.jetty.handler;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class HeaderWriterHandler
extends Handler.Wrapper {
    protected static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    protected static final String CONTENT_SECURITY_POLICY = "frame-ancestors 'self'";
    protected static final String FRAME_OPTIONS_HEADER = "X-Frame-Options";
    protected static final String FRAME_OPTIONS = "SAMEORIGIN";
    protected static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    protected static final String STRICT_TRANSPORT_SECURITY = "max-age=31540000";
    protected static final String XSS_PROTECTION_HEADER = "X-XSS-Protection";
    protected static final String XSS_PROTECTION = "1; mode=block";

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        response.getHeaders().add(CONTENT_SECURITY_POLICY_HEADER, CONTENT_SECURITY_POLICY);
        response.getHeaders().add(FRAME_OPTIONS_HEADER, FRAME_OPTIONS);
        response.getHeaders().add(XSS_PROTECTION_HEADER, XSS_PROTECTION);
        if (request.isSecure()) {
            response.getHeaders().add(STRICT_TRANSPORT_SECURITY_HEADER, STRICT_TRANSPORT_SECURITY);
        }
        return super.handle(request, response, callback);
    }
}

