/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.NiFiRegistryClientFactory;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.command.registry.bucket.ListBuckets;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.ExportFlowVersion;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.ListFlowVersions;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.ListFlows;
import org.apache.nifi.toolkit.cli.impl.result.registry.VersionedFlowSnapshotsResult;

public class ExportAllFlows
extends AbstractNiFiRegistryCommand<VersionedFlowSnapshotsResult> {
    private static final String ALL_BUCKETS_COLLECTED = "All buckets collected...";
    private static final String ALL_FLOWS_COLLECTED = "All flows collected...";
    private static final String ALL_FLOW_VERSIONS_COLLECTED = "All flow versions collected...";
    private final ListBuckets listBuckets = new ListBuckets();
    private final ListFlows listFlows = new ListFlows();
    private final ListFlowVersions listFlowVersions = new ListFlowVersions();

    public ExportAllFlows() {
        super("export-all-flows", VersionedFlowSnapshotsResult.class);
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.OUTPUT_DIR.createOption());
        this.listBuckets.initialize(context);
        this.listFlows.initialize(context);
        this.listFlowVersions.initialize(context);
    }

    @Override
    public String getDescription() {
        return "List all the buckets, for each bucket, list all the flows, for each flow, list all versions and export each version.Versions will be saved in the provided target directory.";
    }

    @Override
    public VersionedFlowSnapshotsResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException, CommandException {
        String outputDirectory = this.getRequiredArg(properties, CommandOption.OUTPUT_DIR);
        boolean isInteractive = this.getContext().isInteractive();
        Map<String, Bucket> bucketMap = this.getBucketMap(client, isInteractive);
        Map<String, VersionedFlow> flowMap = this.getFlowMap(client, bucketMap, isInteractive);
        List<VersionedFlowSnapshotMetadata> versionedFlowSnapshotMetadataList = this.getVersionedFlowSnapshotMetadataList(client, flowMap, isInteractive);
        ExportAllFlowSnapshotIterator versionedFlowSnapshotIterator = new ExportAllFlowSnapshotIterator(properties, outputDirectory, bucketMap, flowMap, versionedFlowSnapshotMetadataList.iterator());
        return new VersionedFlowSnapshotsResult(versionedFlowSnapshotIterator, outputDirectory);
    }

    private Map<String, Bucket> getBucketMap(NiFiRegistryClient client, boolean isInteractive) throws IOException, NiFiRegistryException {
        this.printMessage(isInteractive, ALL_BUCKETS_COLLECTED);
        return this.listBuckets.doExecute(client, new Properties()).getResult().stream().collect(Collectors.toMap(Bucket::getIdentifier, Function.identity()));
    }

    private Map<String, VersionedFlow> getFlowMap(NiFiRegistryClient client, Map<String, Bucket> bucketMap, boolean isInteractive) throws IOException, NiFiRegistryException, ParseException {
        this.printMessage(isInteractive, ALL_FLOWS_COLLECTED);
        return this.getFlows(client, bucketMap).stream().collect(Collectors.toMap(BucketItem::getIdentifier, Function.identity()));
    }

    private List<VersionedFlow> getFlows(NiFiRegistryClient client, Map<String, Bucket> bucketMap) throws ParseException, IOException, NiFiRegistryException {
        ArrayList<VersionedFlow> versionedFlowList = new ArrayList<VersionedFlow>();
        for (String bucketId : bucketMap.keySet()) {
            Properties listFlowProperties = new Properties();
            listFlowProperties.setProperty(CommandOption.BUCKET_ID.getLongName(), bucketId);
            versionedFlowList.addAll((Collection<VersionedFlow>)this.listFlows.doExecute(client, listFlowProperties).getResult());
        }
        return versionedFlowList;
    }

    private List<VersionedFlowSnapshotMetadata> getVersionedFlowSnapshotMetadataList(NiFiRegistryClient client, Map<String, VersionedFlow> flowMap, boolean isInteractive) throws ParseException, IOException, NiFiRegistryException {
        ArrayList<VersionedFlowSnapshotMetadata> versionedFlowSnapshotMetadataList = new ArrayList<VersionedFlowSnapshotMetadata>();
        for (String flowId : flowMap.keySet()) {
            Properties listFlowVersionsProperties = new Properties();
            listFlowVersionsProperties.setProperty(CommandOption.FLOW_ID.getLongName(), flowId);
            versionedFlowSnapshotMetadataList.addAll((Collection<VersionedFlowSnapshotMetadata>)this.listFlowVersions.doExecute(client, listFlowVersionsProperties).getResult());
        }
        this.printMessage(isInteractive, ALL_FLOW_VERSIONS_COLLECTED);
        return versionedFlowSnapshotMetadataList;
    }

    private void printMessage(boolean isInteractive, String message) {
        if (isInteractive) {
            this.println();
            this.println(message);
            this.println();
        }
    }

    public static class ExportAllFlowSnapshotIterator
    implements Iterator<VersionedFlowSnapshot> {
        private final NiFiRegistryClient client;
        private final String outputDirectory;
        private final Map<String, Bucket> bucketMap;
        private final Map<String, VersionedFlow> flowMap;
        private final Iterator<VersionedFlowSnapshotMetadata> metadataIterator;
        private final ExportFlowVersion exportFlowVersion = new ExportFlowVersion();

        public ExportAllFlowSnapshotIterator(Properties properties, String outputDirectory, Map<String, Bucket> bucketMap, Map<String, VersionedFlow> flowMap, Iterator<VersionedFlowSnapshotMetadata> metaDataIterator) throws MissingOptionException {
            this.client = new NiFiRegistryClientFactory().createClient(properties);
            this.outputDirectory = outputDirectory;
            this.bucketMap = bucketMap;
            this.flowMap = flowMap;
            this.metadataIterator = metaDataIterator;
        }

        @Override
        public boolean hasNext() {
            return this.metadataIterator.hasNext();
        }

        @Override
        public VersionedFlowSnapshot next() {
            try {
                return this.setNextElement();
            }
            catch (IOException | ParseException | NiFiRegistryException e) {
                throw new RuntimeException(e);
            }
        }

        private VersionedFlowSnapshot setNextElement() throws ParseException, IOException, NiFiRegistryException {
            VersionedFlowSnapshotMetadata metaData = this.metadataIterator.next();
            Properties exportFlowVersionProperties = new Properties();
            exportFlowVersionProperties.setProperty(CommandOption.FLOW_ID.getLongName(), metaData.getFlowIdentifier());
            exportFlowVersionProperties.setProperty(CommandOption.FLOW_VERSION.getLongName(), Integer.toString(metaData.getVersion()));
            exportFlowVersionProperties.setProperty(CommandOption.OUTPUT_FILE.getLongName(), this.outputDirectory);
            VersionedFlowSnapshot exportedSnapshot = this.exportFlowVersion.doExecute(this.client, exportFlowVersionProperties).getResult();
            VersionedFlow flow = new VersionedFlow();
            flow.setIdentifier(metaData.getFlowIdentifier());
            flow.setName(this.flowMap.get(metaData.getFlowIdentifier()).getName());
            flow.setDescription(this.flowMap.get(metaData.getFlowIdentifier()).getDescription());
            exportedSnapshot.setFlow(flow);
            Bucket bucket = new Bucket();
            bucket.setIdentifier(metaData.getBucketIdentifier());
            bucket.setName(this.bucketMap.get(metaData.getBucketIdentifier()).getName());
            bucket.setDescription(this.bucketMap.get(metaData.getBucketIdentifier()).getDescription());
            exportedSnapshot.setBucket(bucket);
            return exportedSnapshot;
        }
    }
}

