/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.UsersAndAccessPolicies;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractPolicyBasedAuthorizer
implements ManagedAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPolicyBasedAuthorizer.class);
    private static final String DISALLOW_DOCTYPES = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String ALLOW_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String ALLOW_EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String ALLOW_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    static final String USER_ELEMENT = "user";
    static final String GROUP_USER_ELEMENT = "groupUser";
    static final String GROUP_ELEMENT = "group";
    static final String POLICY_ELEMENT = "policy";
    static final String POLICY_USER_ELEMENT = "policyUser";
    static final String POLICY_GROUP_ELEMENT = "policyGroup";
    static final String IDENTIFIER_ATTR = "identifier";
    static final String IDENTITY_ATTR = "identity";
    static final String NAME_ATTR = "name";
    static final String RESOURCE_ATTR = "resource";
    static final String ACTIONS_ATTR = "actions";

    @Override
    public final void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        this.doOnConfigured(configurationContext);
    }

    protected abstract void doOnConfigured(AuthorizerConfigurationContext var1) throws AuthorizerCreationException;

    @Override
    public final AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
        String resourceIdentifier;
        UsersAndAccessPolicies usersAndAccessPolicies = this.getUsersAndAccessPolicies();
        AccessPolicy policy = usersAndAccessPolicies.getAccessPolicy(resourceIdentifier = request.getResource().getIdentifier(), request.getAction());
        if (policy == null) {
            return AuthorizationResult.resourceNotFound();
        }
        User user = usersAndAccessPolicies.getUser(request.getIdentity());
        if (user == null) {
            return AuthorizationResult.denied(String.format("Unknown user with identity '%s'.", request.getIdentity()));
        }
        Set<Group> userGroups = usersAndAccessPolicies.getGroups(user.getIdentity());
        if (policy.getUsers().contains(user.getIdentifier()) || this.containsGroup(userGroups, policy)) {
            return AuthorizationResult.approved();
        }
        return AuthorizationResult.denied(request.getExplanationSupplier().get());
    }

    private boolean containsGroup(Set<Group> userGroups, AccessPolicy policy) {
        if (userGroups.isEmpty() || policy.getGroups().isEmpty()) {
            return false;
        }
        for (Group userGroup : userGroups) {
            if (!policy.getGroups().contains(userGroup.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public final synchronized Group addGroup(Group group) throws AuthorizationAccessException {
        return this.doAddGroup(group);
    }

    public abstract Group doAddGroup(Group var1) throws AuthorizationAccessException;

    public abstract Group getGroup(String var1) throws AuthorizationAccessException;

    public abstract Group getGroupByName(String var1) throws AuthorizationAccessException;

    protected abstract void purgePoliciesUsersAndGroups();

    protected abstract void backupPoliciesUsersAndGroups();

    public final synchronized Group updateGroup(Group group) throws AuthorizationAccessException {
        return this.doUpdateGroup(group);
    }

    public abstract Group doUpdateGroup(Group var1) throws AuthorizationAccessException;

    public abstract Group deleteGroup(Group var1) throws AuthorizationAccessException;

    public abstract Set<Group> getGroups() throws AuthorizationAccessException;

    public final synchronized User addUser(User user) throws AuthorizationAccessException {
        return this.doAddUser(user);
    }

    public abstract User doAddUser(User var1) throws AuthorizationAccessException;

    public abstract User getUser(String var1) throws AuthorizationAccessException;

    public abstract User getUserByIdentity(String var1) throws AuthorizationAccessException;

    public final synchronized User updateUser(User user) throws AuthorizationAccessException {
        return this.doUpdateUser(user);
    }

    public abstract User doUpdateUser(User var1) throws AuthorizationAccessException;

    public abstract User deleteUser(User var1) throws AuthorizationAccessException;

    public abstract Set<User> getUsers() throws AuthorizationAccessException;

    public final synchronized AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.doAddAccessPolicy(accessPolicy);
    }

    protected abstract AccessPolicy doAddAccessPolicy(AccessPolicy var1) throws AuthorizationAccessException;

    public abstract AccessPolicy getAccessPolicy(String var1) throws AuthorizationAccessException;

    public abstract AccessPolicy updateAccessPolicy(AccessPolicy var1) throws AuthorizationAccessException;

    public abstract AccessPolicy deleteAccessPolicy(AccessPolicy var1) throws AuthorizationAccessException;

    public abstract Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException;

    public abstract UsersAndAccessPolicies getUsersAndAccessPolicies() throws AuthorizationAccessException;

    @Override
    public final void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        PoliciesUsersAndGroups policiesUsersAndGroups;
        try {
            policiesUsersAndGroups = this.parsePoliciesUsersAndGroups(proposedFingerprint);
        }
        catch (AuthorizationAccessException e) {
            throw new UninheritableAuthorizationsException("Unable to parse proposed fingerprint: " + String.valueOf(e));
        }
        if (!this.isInheritable(policiesUsersAndGroups)) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current Authorizations is not empty.");
        }
    }

    private boolean isInheritable(PoliciesUsersAndGroups policiesUsersAndGroups) {
        return this.getUsers().isEmpty() && this.getGroups().isEmpty() && this.getAccessPolicies().isEmpty();
    }

    @Override
    public final void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (fingerprint == null || fingerprint.isBlank()) {
            return;
        }
        PoliciesUsersAndGroups policiesUsersAndGroups = this.parsePoliciesUsersAndGroups(fingerprint);
        this.inheritPoliciesUsersAndGroups(policiesUsersAndGroups);
    }

    private void inheritPoliciesUsersAndGroups(PoliciesUsersAndGroups policiesUsersAndGroups) {
        this.addPoliciesUsersAndGroups(policiesUsersAndGroups);
    }

    private void addPoliciesUsersAndGroups(PoliciesUsersAndGroups policiesUsersAndGroups) {
        policiesUsersAndGroups.getUsers().forEach(this::addUser);
        policiesUsersAndGroups.getGroups().forEach(this::addGroup);
        policiesUsersAndGroups.getAccessPolicies().forEach(this::addAccessPolicy);
    }

    @Override
    public void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (fingerprint == null || fingerprint.isBlank()) {
            logger.info("Inheriting Empty Policies, Users & Groups. Will backup existing Policies, Users & Groups first.");
            this.backupPoliciesUsersAndGroups();
            this.purgePoliciesUsersAndGroups();
            return;
        }
        PoliciesUsersAndGroups policiesUsersAndGroups = this.parsePoliciesUsersAndGroups(fingerprint);
        if (this.isInheritable(policiesUsersAndGroups)) {
            logger.debug("Inheriting Policies, Users & Groups");
            this.inheritPoliciesUsersAndGroups(policiesUsersAndGroups);
        } else {
            logger.info("Cannot directly inherit Policies, Users & Groups. Will backup existing Policies, Users & Groups, and then replace with proposed configuration");
            this.backupPoliciesUsersAndGroups();
            this.purgePoliciesUsersAndGroups();
            this.addPoliciesUsersAndGroups(policiesUsersAndGroups);
        }
    }

    private PoliciesUsersAndGroups parsePoliciesUsersAndGroups(String fingerprint) {
        ArrayList<AccessPolicy> accessPolicies = new ArrayList<AccessPolicy>();
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<Group> groups = new ArrayList<Group>();
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            Document document = this.parseFingerprint(in);
            Element rootElement = document.getDocumentElement();
            NodeList userNodes = rootElement.getElementsByTagName(USER_ELEMENT);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                users.add(this.parseUser((Element)userNode));
            }
            NodeList groupNodes = rootElement.getElementsByTagName(GROUP_ELEMENT);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                groups.add(this.parseGroup((Element)groupNode));
            }
            NodeList policyNodes = rootElement.getElementsByTagName(POLICY_ELEMENT);
            for (int i = 0; i < policyNodes.getLength(); ++i) {
                Node policyNode = policyNodes.item(i);
                accessPolicies.add(this.parsePolicy((Element)policyNode));
            }
        }
        catch (IOException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", e);
        }
        return new PoliciesUsersAndGroups(accessPolicies, users, groups);
    }

    private Document parseFingerprint(InputStream inputStream) throws IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setSchema(null);
        docFactory.setNamespaceAware(true);
        docFactory.setAttribute(DISALLOW_DOCTYPES, true);
        docFactory.setAttribute(ALLOW_EXTERNAL_DTD, false);
        docFactory.setAttribute(ALLOW_EXTERNAL_GENERAL_ENTITIES, false);
        docFactory.setAttribute(ALLOW_EXTERNAL_PARAM_ENTITIES, false);
        docFactory.setXIncludeAware(false);
        docFactory.setExpandEntityReferences(false);
        try {
            docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder documentBuilder = docFactory.newDocumentBuilder();
            return documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Fingerprint parsing failed", e);
        }
    }

    private User parseUser(Element element) {
        User.Builder builder = new User.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).identity(element.getAttribute(IDENTITY_ATTR));
        return builder.build();
    }

    private Group parseGroup(Element element) {
        Group.Builder builder = new Group.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).name(element.getAttribute(NAME_ATTR));
        NodeList groupUsers = element.getElementsByTagName(GROUP_USER_ELEMENT);
        for (int i = 0; i < groupUsers.getLength(); ++i) {
            Element groupUserNode = (Element)groupUsers.item(i);
            builder.addUser(groupUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private AccessPolicy parsePolicy(Element element) {
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).resource(element.getAttribute(RESOURCE_ATTR));
        String actions = element.getAttribute(ACTIONS_ATTR);
        if (actions.equals(RequestAction.READ.name())) {
            builder.action(RequestAction.READ);
        } else if (actions.equals(RequestAction.WRITE.name())) {
            builder.action(RequestAction.WRITE);
        } else {
            throw new IllegalStateException("Unknown Policy Action: " + actions);
        }
        NodeList policyUsers = element.getElementsByTagName(POLICY_USER_ELEMENT);
        for (int i = 0; i < policyUsers.getLength(); ++i) {
            Element policyUserNode = (Element)policyUsers.item(i);
            builder.addUser(policyUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        NodeList policyGroups = element.getElementsByTagName(POLICY_GROUP_ELEMENT);
        for (int i = 0; i < policyGroups.getLength(); ++i) {
            Element policyGroupNode = (Element)policyGroups.item(i);
            builder.addGroup(policyGroupNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    @Override
    public final AccessPolicyProvider getAccessPolicyProvider() {
        return new ConfigurableAccessPolicyProvider(){

            @Override
            public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
                return AbstractPolicyBasedAuthorizer.this.getAccessPolicies();
            }

            @Override
            public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
                return AbstractPolicyBasedAuthorizer.this.getAccessPolicy(identifier);
            }

            @Override
            public AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                return AbstractPolicyBasedAuthorizer.this.addAccessPolicy(accessPolicy);
            }

            @Override
            public AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                return AbstractPolicyBasedAuthorizer.this.updateAccessPolicy(accessPolicy);
            }

            @Override
            public AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                return AbstractPolicyBasedAuthorizer.this.deleteAccessPolicy(accessPolicy);
            }

            @Override
            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
                UsersAndAccessPolicies usersAndAccessPolicies = AbstractPolicyBasedAuthorizer.this.getUsersAndAccessPolicies();
                return usersAndAccessPolicies.getAccessPolicy(resourceIdentifier, action);
            }

            @Override
            public String getFingerprint() throws AuthorizationAccessException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                throw new UnsupportedOperationException();
            }

            @Override
            public UserGroupProvider getUserGroupProvider() {
                return new ConfigurableUserGroupProvider(){

                    @Override
                    public User addUser(User user) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.addUser(user);
                    }

                    @Override
                    public User updateUser(User user) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.updateUser(user);
                    }

                    @Override
                    public User deleteUser(User user) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.deleteUser(user);
                    }

                    @Override
                    public Group addGroup(Group group) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.addGroup(group);
                    }

                    @Override
                    public Group updateGroup(Group group) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.updateGroup(group);
                    }

                    @Override
                    public Group deleteGroup(Group group) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.deleteGroup(group);
                    }

                    @Override
                    public Set<User> getUsers() throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.getUsers();
                    }

                    @Override
                    public User getUser(String identifier) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.getUser(identifier);
                    }

                    @Override
                    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.getUserByIdentity(identity);
                    }

                    @Override
                    public Set<Group> getGroups() throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.getGroups();
                    }

                    @Override
                    public Group getGroup(String identifier) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.getGroup(identifier);
                    }

                    @Override
                    public Group getGroupByName(String name) throws AuthorizationAccessException {
                        return AbstractPolicyBasedAuthorizer.this.getGroupByName(name);
                    }

                    @Override
                    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
                        UsersAndAccessPolicies usersAndAccessPolicies = AbstractPolicyBasedAuthorizer.this.getUsersAndAccessPolicies();
                        final User user = usersAndAccessPolicies.getUser(identity);
                        final Set<Group> groups = usersAndAccessPolicies.getGroups(identity);
                        return new UserAndGroups(){

                            @Override
                            public User getUser() {
                                return user;
                            }

                            @Override
                            public Set<Group> getGroups() {
                                return groups;
                            }
                        };
                    }

                    @Override
                    public String getFingerprint() throws AuthorizationAccessException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void initialize(UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
                    }

                    @Override
                    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                    }

                    @Override
                    public void preDestruction() throws AuthorizerDestructionException {
                    }
                };
            }

            @Override
            public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws AuthorizerCreationException {
            }

            @Override
            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
            }

            @Override
            public void preDestruction() throws AuthorizerDestructionException {
            }
        };
    }

    @Override
    public final String getFingerprint() throws AuthorizationAccessException {
        List<User> users = this.getSortedUsers();
        List<Group> groups = this.getSortedGroups();
        List<AccessPolicy> policies = this.getSortedAccessPolicies();
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("authorizations");
            for (User user : users) {
                this.writeUser(writer, user);
            }
            for (Group group : groups) {
                this.writeGroup(writer, group);
            }
            for (AccessPolicy policy : policies) {
                this.writePolicy(writer, policy);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private void writeUser(XMLStreamWriter writer, User user) throws XMLStreamException {
        writer.writeStartElement(USER_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, user.getIdentifier());
        writer.writeAttribute(IDENTITY_ATTR, user.getIdentity());
        writer.writeEndElement();
    }

    private void writeGroup(XMLStreamWriter writer, Group group) throws XMLStreamException {
        ArrayList<String> users = new ArrayList<String>(group.getUsers());
        Collections.sort(users);
        writer.writeStartElement(GROUP_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, group.getIdentifier());
        writer.writeAttribute(NAME_ATTR, group.getName());
        for (String user : users) {
            writer.writeStartElement(GROUP_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, user);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePolicy(XMLStreamWriter writer, AccessPolicy policy) throws XMLStreamException {
        ArrayList<String> policyUsers = new ArrayList<String>(policy.getUsers());
        Collections.sort(policyUsers);
        ArrayList<String> policyGroups = new ArrayList<String>(policy.getGroups());
        Collections.sort(policyGroups);
        writer.writeStartElement(POLICY_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, policy.getIdentifier());
        writer.writeAttribute(RESOURCE_ATTR, policy.getResource());
        writer.writeAttribute(ACTIONS_ATTR, policy.getAction().name());
        for (String policyUser : policyUsers) {
            writer.writeStartElement(POLICY_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyUser);
            writer.writeEndElement();
        }
        for (String policyGroup : policyGroups) {
            writer.writeStartElement(POLICY_GROUP_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyGroup);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private List<AccessPolicy> getSortedAccessPolicies() {
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>(this.getAccessPolicies());
        policies.sort(Comparator.comparing(AccessPolicy::getIdentifier));
        return policies;
    }

    private List<Group> getSortedGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.getGroups());
        groups.sort(Comparator.comparing(Group::getIdentifier));
        return groups;
    }

    private List<User> getSortedUsers() {
        ArrayList<User> users = new ArrayList<User>(this.getUsers());
        users.sort(Comparator.comparing(User::getIdentifier));
        return users;
    }

    private static class PoliciesUsersAndGroups {
        final List<AccessPolicy> accessPolicies;
        final List<User> users;
        final List<Group> groups;

        public PoliciesUsersAndGroups(List<AccessPolicy> accessPolicies, List<User> users, List<Group> groups) {
            this.accessPolicies = accessPolicies;
            this.users = users;
            this.groups = groups;
        }

        public List<AccessPolicy> getAccessPolicies() {
            return this.accessPolicies;
        }

        public List<User> getUsers() {
            return this.users;
        }

        public List<Group> getGroups() {
            return this.groups;
        }
    }
}

