<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# Apache NetBeans Standalone Java Hints

This tool allows to run NetBeans Java code checker without the NetBeans IDE. This includes running the custom Java hints specified in META-INF/upgrade/*.hint.

### Requirements

#### To Build

* Apache NetBeans 28
* JDK 17, JDK 21 and JDK 25
* bash
* Apache ant 1.9.9 or above
* Apache Maven 3.3.9 or above

#### To Run

* JDK 17-25

### Building

Build using:

```
$ ant -DNETBEANS_PLATFORM=<path-to-NetBeans-28> -DJDK17=<path-to-JDK-17> -DJDK21=<path-to-JDK-21> -DJDK25=<path-to-JDK25> build-and-test
```

The built product is in tool/build/jackpot.

### Running

Run using:

```
$ jackpot <options> <files-to-inspect>
```

To get help on the options, run:

```
$ jackpot --help
```

### Example

Consider this sample code:

```
package test;

public class Test {
    public void test(boolean b) {
        int i = 0;
        if (b)
            System.err.println("was true");
            assert (i = 1) == 1;
    }
}
```

It is possible to get a warning for the improper indentation like this:
```
$ jackpot --hint "Confusing indentation" <somedir>/src
<somedir>/src/test/Test.java:9: warning: [Confusing_indentation] Confusing indentation
            assert (i = 1) == 1;
            ^
```

Or a warning for the side-effects inside the assert:
```
$ jackpot --hint "Assert with side effects" <somedir>/src
<somedir>/src/test/Test.java:9: warning: [Assert_with_side_effects] Assert condition produces side effects
            assert (i = 1) == 1;
                    ^
```

All supported hints can be listed using:
```
$ jackpot --list
```

It is also possible to use a configuration file which enables multiple hints at once using:
```
$ jackpot --config-file <path-to-config-file> <path-to-sources-to-check>
```

The config file can be generated by the NetBeans IDE, using Project Properties/Hints, or similar ways.
