/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jpt30.annotation.processing.AbstractProcessor;
import jpt30.annotation.processing.Filer;
import jpt30.annotation.processing.Messager;
import jpt30.annotation.processing.RoundEnvironment;
import jpt30.annotation.processing.SupportedSourceVersion;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.TypeElement;
import jpt30.tools.Diagnostic;
import jpt30.tools.FileObject;
import jpt30.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class LayerGeneratingProcessor
extends AbstractProcessor {
    private static final String GENERATED_LAYER = "META-INF/generated-layer.xml";
    private static final String PUBLIC_DTD_ID = "-//NetBeans//DTD Filesystem 1.2//EN";
    private static final String NETWORK_DTD_URL = "http://www.netbeans.org/dtds/filesystem-1_2.dtd";
    private static final String LOCAL_DTD_RESOURCE = "/org/openide/filesystems/filesystem1_2.dtd";
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };
    private static final EntityResolver ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (LayerGeneratingProcessor.PUBLIC_DTD_ID.equals(publicId)) {
                return new InputSource(LayerGeneratingProcessor.class.getResource(LayerGeneratingProcessor.LOCAL_DTD_RESOURCE).toString());
            }
            return null;
        }
    };
    private static final Map<Filer, Document> generatedLayerByProcessor = new WeakHashMap<Filer, Document>();
    private static final Map<Filer, Collection<Element>> originatingElementsByProcessor = new WeakHashMap<Filer, Collection<Element>>();
    private final List<LayerBuilder> createdBuilders = new LinkedList<LayerBuilder>();

    protected LayerGeneratingProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ret;
        Messager messager = this.processingEnv.getMessager();
        try {
            ret = this.handleProcess(annotations, roundEnv);
        }
        catch (LayerGenerationException x) {
            if (x.erroneousAnnotationValue != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage(), x.erroneousElement, x.erroneousAnnotation, x.erroneousAnnotationValue);
            } else if (x.erroneousAnnotation != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage(), x.erroneousElement, x.erroneousAnnotation);
            } else if (x.erroneousElement != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage(), x.erroneousElement);
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage());
            }
            return false;
        }
        if (roundEnv.processingOver()) {
            Filer filer = this.processingEnv.getFiler();
            Document doc = generatedLayerByProcessor.remove(filer);
            Collection<Element> originatingElementsL = originatingElementsByProcessor.remove(filer);
            if (doc != null && !roundEnv.errorRaised()) {
                Element[] originatingElementsA = new Element[]{};
                if (originatingElementsL != null) {
                    originatingElementsA = originatingElementsL.toArray(originatingElementsA);
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
                    assert (ls != null) : "No DOM 3 LS supported in " + doc.getClass().getName();
                    LSOutput output = ls.createLSOutput();
                    output.setEncoding("UTF-8");
                    output.setByteStream(baos);
                    LSSerializer ser = ls.createLSSerializer();
                    String fpp = "format-pretty-print";
                    if (ser.getDomConfig().canSetParameter(fpp, true)) {
                        ser.getDomConfig().setParameter(fpp, true);
                    }
                    ser.write(doc, output);
                    byte[] data = baos.toByteArray();
                    XMLUtil.parse(new InputSource(new ByteArrayInputStream(data)), true, true, ERROR_HANDLER, ENTITY_RESOLVER);
                    FileObject layer = filer.createResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER, originatingElementsA);
                    try (OutputStream os = layer.openOutputStream();){
                        os.write(data);
                    }
                }
                catch (IOException x) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write generated-layer.xml: " + x.toString());
                }
                catch (SAXException x) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Refused to write invalid generated-layer.xml: " + x.toString());
                }
            }
            for (LayerBuilder b : this.createdBuilders) {
                b.close();
            }
            this.createdBuilders.clear();
        }
        return ret;
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws LayerGenerationException;

    protected final LayerBuilder layer(Element ... originatingElements) {
        LayerBuilder b = new LayerBuilder(this.layerDocument(originatingElements), originatingElements.length == 1 ? originatingElements[0] : null, this.processingEnv);
        this.createdBuilders.add(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document layerDocument(Element ... originatingElements) {
        Filer filer = this.processingEnv.getFiler();
        Collection<Element> originatingElementsL = originatingElementsByProcessor.get(filer);
        if (originatingElementsL == null) {
            originatingElementsL = Collections.newSetFromMap(new WeakHashMap());
            originatingElementsByProcessor.put(filer, originatingElementsL);
        }
        originatingElementsL.addAll(Arrays.asList(originatingElements));
        Document doc = generatedLayerByProcessor.get(filer);
        if (doc == null) {
            try {
                FileObject layer = filer.getResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER);
                try (InputStream is = layer.openInputStream();){
                    doc = XMLUtil.parse(new InputSource(is), true, true, ERROR_HANDLER, ENTITY_RESOLVER);
                }
            }
            catch (FileNotFoundException | NoSuchFileException layer) {
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read generated-layer.xml: " + x.toString());
            }
            catch (SAXException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to parse generated-layer.xml: " + x.toString());
            }
            if (doc == null) {
                doc = XMLUtil.createDocument("filesystem", null, PUBLIC_DTD_ID, NETWORK_DTD_URL);
            }
            generatedLayerByProcessor.put(filer, doc);
        }
        return doc;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion ssv = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sv = ssv == null ? SourceVersion.latest() : ssv.value();
        return sv;
    }
}

