/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import java.util.Set;

public class ResetValuesUtils {
    private ResetValuesUtils() {
    }

    public static void resetValues(FacesContext context, UIViewRoot viewRoot, Collection<String> clientIds) {
        ResetValuesUtils.resetValues(context, viewRoot, clientIds, null);
    }

    public static void resetValues(FacesContext context, UIViewRoot viewRoot, Collection<String> clientIds, Set<VisitHint> visitHints) {
        if (clientIds == null || clientIds.isEmpty()) {
            return;
        }
        VisitContext visitContext = null;
        ResetInputContextCallback contextCallback = null;
        for (String clientId : clientIds) {
            if (clientId == null || clientId.isBlank() || "@none".equals(clientId)) continue;
            if (visitContext == null) {
                visitContext = VisitContext.createVisitContext(context, null, visitHints);
            }
            if ("@all".equals(clientId) || "jakarta.faces.ViewRoot".equals(clientId)) {
                viewRoot.visitTree(visitContext, ResetInputVisitCallback.INSTANCE);
                continue;
            }
            if (contextCallback == null) {
                contextCallback = new ResetInputContextCallback(visitContext);
            }
            viewRoot.invokeOnComponent(context, clientId, contextCallback);
        }
    }

    public static class ResetInputVisitCallback
    implements VisitCallback {
        public static final ResetInputVisitCallback INSTANCE = new ResetInputVisitCallback();

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)((Object)target);
                input.resetValue();
            }
            return VisitResult.ACCEPT;
        }
    }

    public static class ResetInputContextCallback
    implements ContextCallback {
        private VisitContext visitContext;

        public ResetInputContextCallback(VisitContext visitContext) {
            this.visitContext = visitContext;
        }

        @Override
        public void invokeContextCallback(FacesContext fc, UIComponent component) {
            if (component instanceof EditableValueHolder) {
                ((EditableValueHolder)((Object)component)).resetValue();
            } else {
                component.visitTree(this.visitContext, ResetInputVisitCallback.INSTANCE);
            }
        }
    }
}

