/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.parser.AbstractDataParser;

public class JsonDataParser1
extends AbstractDataParser<ByteBuffer>
implements Serializable {
    private final ObjectMapper MAPPER = new ObjectMapper();

    protected Map<String, Object> parse(ByteBuffer byteBuffer) {
        Map inputMap = (Map)this.MAPPER.readValue(byteBuffer.array(), HashMap.class);
        HashMap outputMap = Maps.newHashMap();
        inputMap.forEach((key, value) -> {
            if (value instanceof Map) {
                HashMap map = (HashMap)value;
                map.forEach((inKey, inValue) -> outputMap.put(key + "_" + inKey, inValue));
            } else if (value instanceof List) {
                ArrayList array = (ArrayList)value;
                for (int i = 0; i < array.size(); ++i) {
                    outputMap.put(key + "_" + i, array.get(i));
                }
            } else {
                outputMap.put(key, value);
            }
        });
        return outputMap;
    }
}

