/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.headers;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.util.annotations.UInt32Primitive;

public class SequenceHeader {
    public static final int SEQUENCE_HEADER_SIZE = 8;
    @UInt32Primitive
    private final long sequenceNumber;
    @UInt32Primitive
    private final long requestId;

    public SequenceHeader(long sequenceNumber, long requestId) {
        this.sequenceNumber = sequenceNumber;
        this.requestId = requestId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceHeader that = (SequenceHeader)o;
        return this.requestId == that.requestId && this.sequenceNumber == that.sequenceNumber;
    }

    public int hashCode() {
        int result = (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
        result = 31 * result + (int)(this.requestId ^ this.requestId >>> 32);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sequenceNumber", this.sequenceNumber).add("requestId", this.requestId).toString();
    }

    public static ByteBuf encode(SequenceHeader header, ByteBuf buffer) {
        buffer.writeIntLE((int)header.getSequenceNumber());
        buffer.writeIntLE((int)header.getRequestId());
        return buffer;
    }

    public static SequenceHeader decode(ByteBuf buffer) {
        return new SequenceHeader(buffer.readUnsignedIntLE(), buffer.readUnsignedIntLE());
    }
}

