/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tool.tsfile.ImportTsFileBase;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;

public class ImportTsFileLocally
extends ImportTsFileBase
implements Runnable {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static SessionPool sessionPool;
    private static boolean verify;

    @Override
    public void loadTsFile() {
        block4: while (true) {
            try {
                String filePath;
                while ((filePath = ImportTsFileScanTool.pollFromQueue()) != null) {
                    String sql = "load '" + filePath + "' onSuccess=none " + (verify ? "" : "verify=false");
                    try {
                        sessionPool.executeNonQueryStatement(sql);
                        ImportTsFileLocally.processSuccessFile(filePath);
                        continue block4;
                    }
                    catch (Exception e) {
                        this.processFailFile(filePath, e);
                    }
                }
                break;
            }
            catch (Exception e) {
                ioTPrinter.println("Unexpected error occurred: " + e.getMessage());
                break;
            }
        }
    }

    public static void setSessionPool(SessionPool sessionPool) {
        ImportTsFileLocally.sessionPool = sessionPool;
    }

    public static void setVerify(boolean verify) {
        ImportTsFileLocally.verify = verify;
    }
}

