/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.Authorizator;
import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.ISessionsRepository;
import io.moquette.broker.MQTTConnection;
import io.moquette.broker.NettyUtils;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.RoutingResults;
import io.moquette.broker.Session;
import io.moquette.broker.SessionEventLoopGroup;
import io.moquette.broker.SessionRegistry;
import io.moquette.broker.SharedSubscriptionUtils;
import io.moquette.broker.Utils;
import io.moquette.broker.scheduler.Expirable;
import io.moquette.broker.scheduler.ScheduledExpirationService;
import io.moquette.broker.subscriptions.ISubscriptionsDirectory;
import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.interception.BrokerInterceptor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodes;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PostOffice {
    private static final String WILL_PUBLISHER = "will_publisher";
    private static final String INTERNAL_PUBLISHER = "internal_publisher";
    public static final String BT_ROUTE_TARGET = "Route to target session";
    public static final String BT_PUB_IN = "PUB in";
    private static final Logger LOG = LoggerFactory.getLogger(PostOffice.class);
    private static final Set<String> NO_FILTER = new HashSet<String>();
    private final Authorizator authorizator;
    private final ISubscriptionsDirectory subscriptions;
    private final IRetainedRepository retainedRepository;
    private final ISessionsRepository sessionRepository;
    private SessionRegistry sessionRegistry;
    private BrokerInterceptor interceptor;
    private final FailedPublishCollection failedPublishes = new FailedPublishCollection();
    private final SessionEventLoopGroup sessionLoops;
    private final Clock clock;
    private final ScheduledExpirationService<ISessionsRepository.Will> willExpirationService;
    private final ScheduledExpirationService<ExpirableTopic> retainedMessagesExpirationService;
    private final MqttQoS maxServerGrantedQos;

    PostOffice(ISubscriptionsDirectory subscriptions, IRetainedRepository retainedRepository, SessionRegistry sessionRegistry, ISessionsRepository sessionRepository, BrokerInterceptor interceptor, Authorizator authorizator, SessionEventLoopGroup sessionLoops) {
        this(subscriptions, retainedRepository, sessionRegistry, sessionRepository, interceptor, authorizator, sessionLoops, Clock.systemDefaultZone());
    }

    PostOffice(ISubscriptionsDirectory subscriptions, IRetainedRepository retainedRepository, SessionRegistry sessionRegistry, ISessionsRepository sessionRepository, BrokerInterceptor interceptor, Authorizator authorizator, SessionEventLoopGroup sessionLoops, Clock clock) {
        this(subscriptions, retainedRepository, sessionRegistry, sessionRepository, interceptor, authorizator, sessionLoops, clock, MqttQoS.EXACTLY_ONCE);
    }

    PostOffice(ISubscriptionsDirectory subscriptions, IRetainedRepository retainedRepository, SessionRegistry sessionRegistry, ISessionsRepository sessionRepository, BrokerInterceptor interceptor, Authorizator authorizator, SessionEventLoopGroup sessionLoops, Clock clock, MqttQoS maxServerGrantedQos) {
        this.authorizator = authorizator;
        this.subscriptions = subscriptions;
        this.retainedRepository = retainedRepository;
        this.sessionRepository = sessionRepository;
        this.sessionRegistry = sessionRegistry;
        this.interceptor = interceptor;
        this.sessionLoops = sessionLoops;
        this.clock = clock;
        this.maxServerGrantedQos = maxServerGrantedQos;
        this.willExpirationService = new ScheduledExpirationService<ISessionsRepository.Will>(clock, this::publishWill);
        this.recreateWillExpires(sessionRepository);
        this.retainedMessagesExpirationService = new ScheduledExpirationService<ExpirableTopic>(clock, this::cleanRetainedExpired);
        this.recreateRetainedExpires(retainedRepository);
    }

    private void cleanRetainedExpired(ExpirableTopic expirable) {
        this.retainedRepository.cleanRetained(expirable.topic);
    }

    private void recreateRetainedExpires(IRetainedRepository retainedRepository) {
        retainedRepository.listExpirable().forEach(this::trackRetainedForExpiry);
    }

    private void trackRetainedForExpiry(RetainedMessage m) {
        ExpirableTopic expirable = new ExpirableTopic(m.getTopic(), m.getExpiryTime());
        this.retainedMessagesExpirationService.track(m.getTopic().toString(), expirable);
    }

    private void recreateWillExpires(ISessionsRepository sessionRepository) {
        sessionRepository.listSessionsWill(this.willExpirationService::track);
    }

    public void fireWill(Session bindedSession) {
        ISessionsRepository.Will will = bindedSession.getWill();
        String clientId = bindedSession.getClientID();
        if (will.delayInterval == 0) {
            this.publishWill(will);
        } else {
            int executionInterval = Math.min(bindedSession.getSessionData().expiryInterval(), will.delayInterval);
            this.trackWillSpecificationForFutureFire(bindedSession, will, clientId, executionInterval);
            LOG.debug("Scheduled will message for client {} on topic {}", (Object)clientId, (Object)will.topic);
        }
    }

    private void trackWillSpecificationForFutureFire(Session bindedSession, ISessionsRepository.Will will, String clientId, int executionInterval) {
        ISessionsRepository.Will willWithEOL = will.withExpirationComputed(executionInterval, this.clock);
        this.sessionRepository.saveWill(bindedSession.getClientID(), willWithEOL);
        this.willExpirationService.track(clientId, willWithEOL);
    }

    private void publishWill(ISessionsRepository.Will will) {
        Map<String, String> willUserProperties;
        Instant messageExpiryInstant = PostOffice.willMessageExpiry(will);
        MqttMessageBuilders.PublishBuilder publishBuilder = MqttMessageBuilders.publish().topicName(will.topic).retained(will.retained).qos(will.qos).payload(Unpooled.copiedBuffer((byte[])will.payload));
        if (will.properties.userProperties().isPresent() && !(willUserProperties = will.properties.userProperties().get()).isEmpty()) {
            publishBuilder.properties(PostOffice.copyWillUserProperties(willUserProperties));
        }
        MqttPublishMessage willPublishMessage = publishBuilder.build();
        this.publish2Subscribers(WILL_PUBLISHER, messageExpiryInstant, willPublishMessage);
    }

    private static MqttProperties copyWillUserProperties(Map<String, String> willUserProperties) {
        MqttProperties.UserProperties userProperties = new MqttProperties.UserProperties();
        for (Map.Entry<String, String> userProperty : willUserProperties.entrySet()) {
            userProperties.add(userProperty.getKey(), userProperty.getValue());
        }
        MqttProperties willProperties = new MqttProperties();
        willProperties.add((MqttProperties.MqttProperty)userProperties);
        return willProperties;
    }

    private static Instant willMessageExpiry(ISessionsRepository.Will will) {
        Optional<Duration> messageExpiryOpt = will.properties.messageExpiry();
        if (messageExpiryOpt.isPresent()) {
            return Instant.now().plus(messageExpiryOpt.get());
        }
        return Instant.MAX;
    }

    public void wipeExistingScheduledWill(String clientId) {
        if (this.willExpirationService.untrack(clientId)) {
            LOG.debug("Wiped task to delayed publish for old client {}", (Object)clientId);
        }
        this.sessionRepository.deleteWill(clientId);
    }

    public void subscribeClientToTopics(MqttSubscribeMessage msg, String clientID, String username, MQTTConnection mqttConnection) {
        Optional<Object> subscriptionIdOpt;
        List<SharedSubscriptionData> sharedSubscriptions;
        int messageID = Utils.messageId((MqttMessage)msg);
        Session session = this.sessionRegistry.retrieve(clientID);
        if (mqttConnection.isProtocolVersion5()) {
            sharedSubscriptions = msg.payload().topicSubscriptions().stream().filter(sub -> SharedSubscriptionUtils.isSharedSubscription(sub.topicName())).map(SharedSubscriptionData::fromMqttSubscription).collect(Collectors.toList());
            Optional<SharedSubscriptionData> invalidSharedSubscription = sharedSubscriptions.stream().filter(subData -> !SharedSubscriptionUtils.validateShareName(subData.name.toString())).findFirst();
            if (invalidSharedSubscription.isPresent()) {
                LOG.info("{} used an invalid shared subscription name {}, disconnecting", (Object)clientID, (Object)invalidSharedSubscription.get().name);
                session.disconnectFromBroker();
                return;
            }
            try {
                subscriptionIdOpt = PostOffice.verifyAndExtractMessageIdentifier(msg);
            }
            catch (IllegalArgumentException ex) {
                session.disconnectFromBroker();
                return;
            }
        } else {
            sharedSubscriptions = Collections.emptyList();
            subscriptionIdOpt = Optional.empty();
        }
        List<MqttTopicSubscription> ackTopics = mqttConnection.isProtocolVersion5() ? this.authorizator.verifyAlsoSharedTopicsReadAccess(clientID, username, msg) : this.authorizator.verifyTopicsReadAccess(clientID, username, msg);
        ackTopics = this.updateWithMaximumSupportedQoS(ackTopics);
        MqttSubAckMessage ackMessage = this.doAckMessageFromValidateFilters(ackTopics, messageID);
        List<Subscription> newSubscriptions = ackTopics.stream().filter(sub -> sub.qualityOfService() != MqttQoS.FAILURE).filter(sub -> !SharedSubscriptionUtils.isSharedSubscription(sub.topicName())).map(sub -> {
            Topic topic = new Topic(sub.topicName());
            MqttSubscriptionOption option = sub.option();
            if (subscriptionIdOpt.isPresent()) {
                return new Subscription(clientID, topic, option, (SubscriptionIdentifier)subscriptionIdOpt.get());
            }
            return new Subscription(clientID, topic, option);
        }).collect(Collectors.toList());
        Set<Subscription> subscriptionToSendRetained = newSubscriptions.stream().map(this::addSubscriptionReportingNewStatus).filter(PostOffice::needToReceiveRetained).map(couple -> (Subscription)couple.v2).collect(Collectors.toSet());
        for (SharedSubscriptionData sharedSubData : sharedSubscriptions) {
            if (subscriptionIdOpt.isPresent()) {
                this.subscriptions.addShared(clientID, sharedSubData.name, sharedSubData.topicFilter, sharedSubData.option, (SubscriptionIdentifier)subscriptionIdOpt.get());
                continue;
            }
            this.subscriptions.addShared(clientID, sharedSubData.name, sharedSubData.topicFilter, sharedSubData.option);
        }
        session.addSubscriptions(newSubscriptions);
        mqttConnection.sendSubAckMessage(messageID, ackMessage);
        this.publishRetainedMessagesForSubscriptions(clientID, subscriptionToSendRetained);
        for (Subscription subscription : newSubscriptions) {
            this.interceptor.notifyTopicSubscribed(subscription, username);
        }
    }

    private static boolean needToReceiveRetained(Utils.Couple<Boolean, Subscription> addedAndSub) {
        MqttSubscriptionOption subOptions = ((Subscription)addedAndSub.v2).option();
        switch (subOptions.retainHandling()) {
            case SEND_AT_SUBSCRIBE: {
                return true;
            }
            case SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS: {
                if (!((Boolean)addedAndSub.v1).booleanValue()) break;
                return true;
            }
        }
        return false;
    }

    private Utils.Couple<Boolean, Subscription> addSubscriptionReportingNewStatus(Subscription subscription) {
        boolean newlyAdded;
        if (subscription.hasSubscriptionIdentifier()) {
            SubscriptionIdentifier subscriptionId = subscription.getSubscriptionIdentifier();
            newlyAdded = this.subscriptions.add(subscription.getClientId(), subscription.getTopicFilter(), subscription.option(), subscriptionId);
        } else {
            newlyAdded = this.subscriptions.add(subscription.getClientId(), subscription.getTopicFilter(), subscription.option());
        }
        return new Utils.Couple<Boolean, Subscription>(newlyAdded, subscription);
    }

    private List<MqttTopicSubscription> updateWithMaximumSupportedQoS(List<MqttTopicSubscription> subscriptions) {
        return subscriptions.stream().map(this::updateWithMaximumSupportedQoS).collect(Collectors.toList());
    }

    private MqttTopicSubscription updateWithMaximumSupportedQoS(MqttTopicSubscription s) {
        MqttQoS grantedQos = PostOffice.minQos(s.qualityOfService(), this.maxServerGrantedQos);
        MqttSubscriptionOption option = PostOffice.optionWithQos(grantedQos, s.option());
        return new MqttTopicSubscription(s.topicName(), option);
    }

    static MqttSubscriptionOption optionWithQos(MqttQoS grantedQos, MqttSubscriptionOption option) {
        return new MqttSubscriptionOption(grantedQos, option.isNoLocal(), option.isRetainAsPublished(), option.retainHandling());
    }

    private static MqttQoS minQos(MqttQoS q1, MqttQoS q2) {
        if (q1 == MqttQoS.FAILURE || q2 == MqttQoS.FAILURE) {
            return MqttQoS.FAILURE;
        }
        return q1.value() < q2.value() ? q1 : q2;
    }

    private static Optional<SubscriptionIdentifier> verifyAndExtractMessageIdentifier(MqttSubscribeMessage msg) {
        List subscriptionIdentifierProperties = msg.idAndPropertiesVariableHeader().properties().getProperties(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value());
        if (subscriptionIdentifierProperties.size() > 1) {
            LOG.warn("Received a Subscribe with more than one subscription identifier property ({})", (Object)subscriptionIdentifierProperties.size());
            throw new IllegalArgumentException("More than one subscription identifier properties");
        }
        if (subscriptionIdentifierProperties.isEmpty()) {
            return Optional.empty();
        }
        Integer value = (Integer)((MqttProperties.MqttProperty)subscriptionIdentifierProperties.iterator().next()).value();
        try {
            return Optional.of(new SubscriptionIdentifier(value));
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Received a Subscribe with SubscriptionIdentifier value {} out of range 1..268435455", (Object)value);
            throw ex;
        }
    }

    private void publishRetainedMessagesForSubscriptions(String clientID, Collection<Subscription> newSubscriptions) {
        Session targetSession = this.sessionRegistry.retrieve(clientID);
        for (Subscription subscription : newSubscriptions) {
            String topicFilter = subscription.getTopicFilter().toString();
            Collection<RetainedMessage> retainedMsgs = this.retainedRepository.retainedOnTopic(topicFilter);
            if (retainedMsgs.isEmpty()) {
                LOG.debug("No retained messages matching topic filter {}", (Object)topicFilter);
                continue;
            }
            for (RetainedMessage retainedMsg : retainedMsgs) {
                MqttProperties.MqttProperty[] properties = this.prepareSubscriptionProperties(subscription, Arrays.asList(retainedMsg.getMqttProperties()));
                MqttQoS retainedQos = retainedMsg.qosLevel();
                MqttQoS qos = PostOffice.lowerQosToTheSubscriptionDesired(subscription, retainedQos);
                ByteBuf payloadBuf = Unpooled.wrappedBuffer((byte[])retainedMsg.getPayload());
                properties = this.appendMessageExpiry(properties, retainedMsg);
                targetSession.sendRetainedPublishOnSessionAtQos(retainedMsg.getTopic(), qos, payloadBuf, properties);
                payloadBuf.release();
            }
        }
    }

    private MqttProperties.MqttProperty[] appendMessageExpiry(MqttProperties.MqttProperty[] properties, RetainedMessage retainedMsg) {
        if (retainedMsg.getExpiryTime() == null) {
            return properties;
        }
        Duration remaining = Duration.between(retainedMsg.getExpiryTime(), Instant.now());
        int remainingSeconds = (int)remaining.toMillis() / 1000;
        MqttProperties.IntegerProperty expiryRemainProp = new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL.value(), Integer.valueOf(remainingSeconds));
        MqttProperties.MqttProperty[] newProperties = new MqttProperties.MqttProperty[properties.length + 1];
        System.arraycopy(properties, 0, newProperties, 0, properties.length);
        newProperties[properties.length] = expiryRemainProp;
        return newProperties;
    }

    private MqttSubAckMessage doAckMessageFromValidateFilters(List<MqttTopicSubscription> topicFilters, int messageId) {
        ArrayList<Integer> grantedQoSLevels = new ArrayList<Integer>();
        for (MqttTopicSubscription req : topicFilters) {
            grantedQoSLevels.add(req.qualityOfService().value());
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttSubAckPayload payload = new MqttSubAckPayload(grantedQoSLevels);
        return new MqttSubAckMessage(fixedHeader, MqttMessageIdVariableHeader.from((int)messageId), payload);
    }

    public void unsubscribe(List<String> topics, MQTTConnection mqttConnection, int messageId) {
        String clientID = mqttConnection.getClientId();
        Session session = this.sessionRegistry.retrieve(clientID);
        if (session == null) {
            LOG.warn("Session not found when unsubscribing {}", (Object)clientID);
            mqttConnection.sendUnsubAckMessage(topics, clientID, messageId);
            return;
        }
        for (String t : topics) {
            Topic topic = new Topic(t);
            boolean validTopic = topic.isValid();
            if (!validTopic) {
                mqttConnection.dropConnection();
                LOG.warn("Topic filter is not valid. topics: {}, offending topic filter: {}", topics, (Object)topic);
                return;
            }
            LOG.trace("Removing subscription topic={}", (Object)topic);
            if (SharedSubscriptionUtils.isSharedSubscription(t)) {
                String topicFilterPart = SharedSubscriptionUtils.extractFilterFromShared(t);
                ShareName shareName = new ShareName(SharedSubscriptionUtils.extractShareName(t));
                this.subscriptions.removeSharedSubscription(shareName, Topic.asTopic(topicFilterPart), clientID);
            } else {
                this.subscriptions.removeSubscription(topic, clientID);
            }
            session.removeSubscription(topic);
            String username = NettyUtils.userName(mqttConnection.channel);
            this.interceptor.notifyTopicUnsubscribed(topic.toString(), clientID, username);
        }
        mqttConnection.sendUnsubAckMessage(topics, clientID, messageId);
    }

    CompletableFuture<Void> receivedPublishQos0(MQTTConnection connection, String username, String clientID, MqttPublishMessage msg, Instant messageExpiry) {
        Topic topic = new Topic(msg.variableHeader().topicName());
        if (!this.authorizator.canWrite(topic, username, clientID)) {
            LOG.error("client is not authorized to publish on topic: {}", (Object)topic);
            Utils.release(msg, "PUB in - ok, auth failed");
            return CompletableFuture.completedFuture(null);
        }
        if (PostOffice.isPayloadFormatToValidate(msg) && !PostOffice.validatePayloadAsUTF8(msg)) {
            LOG.warn("Received not valid UTF-8 payload when payload format indicator was enabled (QoS0)");
            Utils.release(msg, "PUB in - ok, invalid format");
            connection.brokerDisconnect(MqttReasonCodes.Disconnect.PAYLOAD_FORMAT_INVALID);
            connection.disconnectSession();
            connection.dropConnection();
            return CompletableFuture.completedFuture(null);
        }
        RoutingResults publishResult = this.publish2Subscribers(clientID, messageExpiry, msg);
        if (publishResult.isAllFailed()) {
            LOG.info("No one publish was successfully enqueued to session loops");
            Utils.release(msg, "PUB in - ok, can't forward to next session loop");
            return CompletableFuture.completedFuture(null);
        }
        return publishResult.completableFuture().thenRun(() -> {
            if (msg.fixedHeader().isRetain()) {
                this.retainedRepository.cleanRetained(topic);
            }
            this.interceptor.notifyTopicPublished(msg, clientID, username);
            Utils.release(msg, "PUB in - ok");
        });
    }

    RoutingResults receivedPublishQos1(MQTTConnection connection, String username, int messageID, MqttPublishMessage msg, Instant messageExpiry) {
        RoutingResults routes;
        Topic topic = new Topic(msg.variableHeader().topicName());
        topic.getTokens();
        if (!topic.isValid()) {
            LOG.warn("Invalid topic format, force close the connection");
            connection.dropConnection();
            Utils.release(msg, "PUB in - ok, qos1 invalid topic");
            return RoutingResults.preroutingError();
        }
        String clientId = connection.getClientId();
        if (!this.authorizator.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client: {} is not authorized to publish on topic: {}", (Object)clientId, (Object)topic);
            Utils.release(msg, "PUB in - ok, qos1 auth failed");
            return RoutingResults.preroutingError();
        }
        if (PostOffice.isPayloadFormatToValidate(msg) && !PostOffice.validatePayloadAsUTF8(msg)) {
            LOG.warn("Received not valid UTF-8 payload when payload format indicator was enabled (QoS1)");
            connection.sendPubAck(messageID, MqttReasonCodes.PubAck.PAYLOAD_FORMAT_INVALID);
            Utils.release(msg, "PUB in - ok, qos1 invalid format");
            return RoutingResults.preroutingError();
        }
        if (PostOffice.isContentTypeToValidate(msg) && !PostOffice.validateContentTypeAsUTF8(msg)) {
            LOG.warn("Received not valid UTF-8 content type (QoS1)");
            Utils.release(msg, "PUB in - ok, qos1 invalid content type");
            connection.brokerDisconnect(MqttReasonCodes.Disconnect.PROTOCOL_ERROR);
            connection.disconnectSession();
            connection.dropConnection();
            return RoutingResults.preroutingError();
        }
        if (msg.fixedHeader().isDup()) {
            Set<String> failedClients = this.failedPublishes.listFailed(clientId, messageID);
            routes = this.publish2Subscribers(clientId, failedClients, messageExpiry, msg);
        } else {
            routes = this.publish2Subscribers(clientId, messageExpiry, msg);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("subscriber routes: {}", (Object)routes);
        }
        if (routes.isAllSuccess()) {
            connection.sendPubAck(messageID);
            this.manageRetain(topic, msg);
            this.interceptor.notifyTopicPublished(msg, clientId, username);
        } else {
            this.failedPublishes.insertAll(messageID, clientId, routes.failedRoutings);
        }
        Utils.release(msg, "PUB in - ok, qos1");
        this.failedPublishes.removeAll(messageID, clientId, routes.successedRoutings);
        return routes;
    }

    private static boolean validatePayloadAsUTF8(MqttPublishMessage msg) {
        byte[] rawPayload = Utils.readBytesAndRewind(msg.payload());
        boolean isValid = true;
        try {
            StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(rawPayload));
        }
        catch (CharacterCodingException ex) {
            isValid = false;
        }
        return isValid;
    }

    private void manageRetain(Topic topic, MqttPublishMessage msg) {
        if (PostOffice.isRetained(msg)) {
            if (!msg.payload().isReadable()) {
                this.retainedRepository.cleanRetained(topic);
                this.retainedMessagesExpirationService.untrack(topic.toString());
            } else {
                MqttProperties publishProperties = msg.variableHeader().properties();
                if (PostOffice.hasProperty(publishProperties, MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL)) {
                    Duration messageExpiry = Duration.ofSeconds(PostOffice.getIntProperty(publishProperties, MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL));
                    Instant expiryTime = Instant.now().plus(messageExpiry);
                    this.retainedRepository.retain(topic, msg, expiryTime);
                    this.retainedMessagesExpirationService.track(topic.toString(), new ExpirableTopic(topic, expiryTime));
                } else {
                    this.retainedRepository.retain(topic, msg);
                }
            }
        }
    }

    private static boolean hasProperty(MqttProperties props, MqttProperties.MqttPropertyType prop) {
        return props.getProperty(prop.value()) != null;
    }

    private static int getIntProperty(MqttProperties props, MqttProperties.MqttPropertyType prop) {
        MqttProperties.MqttProperty mqttProperty = props.getProperty(prop.value());
        return (Integer)mqttProperty.value();
    }

    private RoutingResults publish2Subscribers(String publisherClientId, Instant messageExpiry, MqttPublishMessage msg) {
        return this.publish2Subscribers(publisherClientId, NO_FILTER, messageExpiry, msg);
    }

    private RoutingResults publish2Subscribers(String publisherClientId, Set<String> filterTargetClients, Instant messageExpiry, MqttPublishMessage msg) {
        boolean retainPublish = msg.fixedHeader().isRetain();
        Topic topic = new Topic(msg.variableHeader().topicName());
        MqttQoS publishingQos = msg.fixedHeader().qosLevel();
        List<Subscription> topicMatchingSubscriptions = this.subscriptions.matchQosSharpening(topic);
        if (topicMatchingSubscriptions.isEmpty()) {
            LOG.trace("No matching subscriptions for topic: {}", (Object)topic);
            return new RoutingResults(Collections.emptyList(), Collections.emptyList(), CompletableFuture.completedFuture(null));
        }
        BatchingPublishesCollector collector = new BatchingPublishesCollector(this.sessionLoops);
        for (Subscription sub : topicMatchingSubscriptions) {
            if (filterTargetClients != NO_FILTER && !filterTargetClients.contains(sub.getClientId())) continue;
            if (sub.option().isNoLocal()) {
                if (publisherClientId.equals(sub.getClientId())) continue;
                collector.add(sub);
                continue;
            }
            collector.add(sub);
        }
        int subscriptionCount = collector.countBatches();
        if (subscriptionCount <= 0) {
            LOG.trace("No matching subscriptions for topic: {}", (Object)topic);
            return new RoutingResults(Collections.emptyList(), Collections.emptyList(), CompletableFuture.completedFuture(null));
        }
        if (subscriptionCount > this.sessionLoops.getEventLoopCount()) {
            LOG.error("Cardinality of subscription batches ({}) is bigger then the available session loops {}", (Object)subscriptionCount, (Object)this.sessionLoops.getEventLoopCount());
            return new RoutingResults(Collections.emptyList(), Collections.emptyList(), CompletableFuture.completedFuture(null));
        }
        Utils.retain(msg, subscriptionCount, BT_ROUTE_TARGET);
        List<RouteResult> publishResults = collector.routeBatchedPublishes(batch -> {
            this.publishToSession(topic, (Collection<Subscription>)batch, publishingQos, retainPublish, messageExpiry, msg);
            Utils.release(msg, BT_ROUTE_TARGET);
        });
        CompletableFuture[] publishFutures = (CompletableFuture[])publishResults.stream().filter(RouteResult::isSuccess).map(RouteResult::completableFuture).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> publishes = CompletableFuture.allOf(publishFutures);
        ArrayList<String> failedRoutings = new ArrayList<String>();
        ArrayList<String> successedRoutings = new ArrayList<String>();
        for (RouteResult rr : publishResults) {
            Collection<String> subscibersIds = collector.subscriberIdsByEventLoop(rr.clientId);
            if (rr.status == RouteResult.Status.FAIL) {
                failedRoutings.addAll(subscibersIds);
                Utils.release(msg, "Route to target session- failed routing");
                continue;
            }
            successedRoutings.addAll(subscibersIds);
        }
        return new RoutingResults(successedRoutings, failedRoutings, publishes);
    }

    private void publishToSession(Topic topic, Collection<Subscription> subscriptions, MqttQoS publishingQos, boolean retainPublish, Instant messageExpiry, MqttPublishMessage msg) {
        ByteBuf duplicatedPayload = msg.payload().duplicate();
        for (Subscription sub : subscriptions) {
            MqttQoS qos = PostOffice.lowerQosToTheSubscriptionDesired(sub, publishingQos);
            boolean retained = false;
            if (sub.option().isRetainAsPublished()) {
                retained = retainPublish;
            }
            this.publishToSession(duplicatedPayload, topic, sub, qos, retained, messageExpiry, msg);
        }
    }

    private void publishToSession(ByteBuf payload, Topic topic, Subscription sub, MqttQoS qos, boolean retained, Instant messageExpiry, MqttPublishMessage msg) {
        boolean isSessionPresent;
        Session targetSession = this.sessionRegistry.retrieve(sub.getClientId());
        boolean bl = isSessionPresent = targetSession != null;
        if (isSessionPresent) {
            LOG.debug("Sending PUBLISH message to active subscriber CId: {}, topicFilter: {}, qos: {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos});
            Collection existingProperties = msg.variableHeader().properties().listAll();
            MqttProperties.MqttProperty[] properties = this.prepareSubscriptionProperties(sub, existingProperties);
            SessionRegistry.PublishedMessage publishedMessage = new SessionRegistry.PublishedMessage(topic, qos, payload, retained, messageExpiry, properties);
            targetSession.sendPublishOnSessionAtQos(publishedMessage);
        } else {
            LOG.debug("PUBLISH to not yet present session. CId: {}, topicFilter: {}, qos: {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos});
        }
    }

    private MqttProperties.MqttProperty[] prepareSubscriptionProperties(Subscription sub, Collection<? extends MqttProperties.MqttProperty> existingProperties) {
        ArrayList<Object> properties = new ArrayList<Object>(existingProperties.size() + 1);
        for (MqttProperties.MqttProperty mqttProperty : existingProperties) {
            if (mqttProperty.propertyId() == MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()) continue;
            properties.add(mqttProperty);
        }
        if (sub.hasSubscriptionIdentifier()) {
            MqttProperties.IntegerProperty subscriptionId = this.createSubscriptionIdProperty(sub);
            properties.add(subscriptionId);
        }
        return properties.toArray(new MqttProperties.MqttProperty[0]);
    }

    private MqttProperties.IntegerProperty createSubscriptionIdProperty(Subscription sub) {
        int subscriptionId = sub.getSubscriptionIdentifier().value();
        return new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(subscriptionId));
    }

    RoutingResults receivedPublishQos2(MQTTConnection connection, MqttPublishMessage msg, String username, Instant messageExpiry) {
        RoutingResults publishRoutings;
        LOG.trace("Processing PUB QoS2 message on connection: {}", (Object)connection);
        Topic topic = new Topic(msg.variableHeader().topicName());
        String clientId = connection.getClientId();
        if (!this.authorizator.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client is not authorized to publish on topic: {}", (Object)topic);
            Utils.release(msg, "PUB in - ok, phase 2 qos2 auth failed");
            return RoutingResults.preroutingError();
        }
        int messageID = msg.variableHeader().packetId();
        if (PostOffice.isPayloadFormatToValidate(msg) && !PostOffice.validatePayloadAsUTF8(msg)) {
            LOG.warn("Received not valid UTF-8 payload when payload format indicator was enabled (QoS2)");
            connection.sendPubRec(messageID, MqttReasonCodes.PubRec.PAYLOAD_FORMAT_INVALID);
            Utils.release(msg, "PUB in - ok, phase 2 qos2 invalid format");
            return RoutingResults.preroutingError();
        }
        if (msg.fixedHeader().isDup()) {
            Set<String> failedClients = this.failedPublishes.listFailed(clientId, messageID);
            publishRoutings = this.publish2Subscribers(clientId, failedClients, messageExpiry, msg);
        } else {
            publishRoutings = this.publish2Subscribers(clientId, messageExpiry, msg);
        }
        if (publishRoutings.isAllSuccess()) {
            connection.sendPubRec(messageID);
            this.manageRetain(topic, msg);
            this.interceptor.notifyTopicPublished(msg, clientId, username);
        } else {
            this.failedPublishes.insertAll(messageID, clientId, publishRoutings.failedRoutings);
        }
        Utils.release(msg, "PUB in - ok, phase 2 qos2");
        this.failedPublishes.removeAll(messageID, clientId, publishRoutings.successedRoutings);
        return publishRoutings;
    }

    static MqttQoS lowerQosToTheSubscriptionDesired(Subscription sub, MqttQoS qos) {
        if (qos.value() > sub.option().qos().value()) {
            qos = sub.option().qos();
        }
        return qos;
    }

    public RoutingResults internalPublish(MqttPublishMessage msg) {
        MqttQoS qos = msg.fixedHeader().qosLevel();
        Topic topic = new Topic(msg.variableHeader().topicName());
        ByteBuf payload = msg.payload();
        LOG.info("Sending internal PUBLISH message Topic={}, qos={}", (Object)topic, (Object)qos);
        RoutingResults publishResult = this.publish2Subscribers(INTERNAL_PUBLISHER, Instant.MAX, msg);
        LOG.trace("after routed publishes: {}", (Object)publishResult);
        if (!PostOffice.isRetained(msg)) {
            return publishResult;
        }
        if (qos == MqttQoS.AT_MOST_ONCE || payload.readableBytes() == 0) {
            this.retainedRepository.cleanRetained(topic);
            return publishResult;
        }
        this.retainedRepository.retain(topic, msg);
        return publishResult;
    }

    private static boolean isRetained(MqttPublishMessage msg) {
        return msg.fixedHeader().isRetain();
    }

    private static boolean isPayloadFormatToValidate(MqttPublishMessage msg) {
        MqttProperties.MqttProperty payloadFormatProperty = msg.variableHeader().properties().getProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value());
        if (payloadFormatProperty == null) {
            return false;
        }
        if (payloadFormatProperty instanceof MqttProperties.IntegerProperty) {
            return (Integer)((MqttProperties.IntegerProperty)payloadFormatProperty).value() == 1;
        }
        return false;
    }

    private static boolean isContentTypeToValidate(MqttPublishMessage msg) {
        MqttProperties.MqttProperty contentTypeProperty = msg.variableHeader().properties().getProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value());
        return contentTypeProperty != null;
    }

    private static boolean validateContentTypeAsUTF8(MqttPublishMessage msg) {
        MqttProperties.StringProperty contentTypeProperty = (MqttProperties.StringProperty)msg.variableHeader().properties().getProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value());
        byte[] rawPayload = ((String)contentTypeProperty.value()).getBytes();
        boolean isValid = true;
        try {
            StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(rawPayload));
        }
        catch (CharacterCodingException ex) {
            isValid = false;
        }
        return isValid;
    }

    void dispatchConnection(MqttConnectMessage msg) {
        this.interceptor.notifyClientConnected(msg);
    }

    void dispatchDisconnection(String clientId, String userName) {
        this.interceptor.notifyClientDisconnected(clientId, userName);
    }

    void dispatchConnectionLost(String clientId, String userName) {
        this.interceptor.notifyClientConnectionLost(clientId, userName);
    }

    String sessionLoopThreadName(String clientId) {
        return this.sessionLoops.sessionLoopThreadName(clientId);
    }

    public RouteResult routeCommand(String clientId, String actionDescription, Callable<Void> action) {
        return this.sessionLoops.routeCommand(clientId, actionDescription, action);
    }

    public void terminate() {
        this.willExpirationService.shutdown();
        this.retainedMessagesExpirationService.shutdown();
        this.sessionLoops.terminate();
    }

    public void clientDisconnected(String clientID, String userName) {
        this.dispatchDisconnection(clientID, userName);
        this.failedPublishes.cleanupForClient(clientID);
    }

    private class BatchingPublishesCollector {
        final List<Subscription>[] subscriptions;
        private final int eventLoops;
        private final SessionEventLoopGroup loopGroup;

        BatchingPublishesCollector(SessionEventLoopGroup loopGroup) {
            this.eventLoops = loopGroup.getEventLoopCount();
            this.loopGroup = loopGroup;
            this.subscriptions = new List[this.eventLoops];
        }

        public void add(Subscription sub) {
            int targetQueueId = this.subscriberEventLoop(sub.getClientId());
            if (this.subscriptions[targetQueueId] == null) {
                this.subscriptions[targetQueueId] = new ArrayList<Subscription>();
            }
            this.subscriptions[targetQueueId].add(sub);
        }

        private int subscriberEventLoop(String clientId) {
            return this.loopGroup.targetQueueOrdinal(clientId);
        }

        List<RouteResult> routeBatchedPublishes(Consumer<List<Subscription>> action) {
            ArrayList<RouteResult> publishResults = new ArrayList<RouteResult>(this.eventLoops);
            for (List<Subscription> subscriptionsBatch : this.subscriptions) {
                if (subscriptionsBatch == null) continue;
                String clientId = subscriptionsBatch.get(0).getClientId();
                if (LOG.isTraceEnabled()) {
                    String subscriptionsDetails = subscriptionsBatch.stream().map(Subscription::toString).collect(Collectors.joining(",\n"));
                    int loopId = this.subscriberEventLoop(clientId);
                    LOG.trace("Routing PUBLISH to eventLoop {}  for subscriptions [{}]", (Object)loopId, (Object)subscriptionsDetails);
                }
                publishResults.add(PostOffice.this.routeCommand(clientId, "batched PUB", () -> {
                    action.accept(subscriptionsBatch);
                    return null;
                }));
            }
            return publishResults;
        }

        Collection<String> subscriberIdsByEventLoop(String clientId) {
            int targetQueueId = this.subscriberEventLoop(clientId);
            return this.subscriptions[targetQueueId].stream().map(Subscription::getClientId).collect(Collectors.toList());
        }

        public int countBatches() {
            int count = 0;
            for (List<Subscription> subscriptionsBatch : this.subscriptions) {
                if (subscriptionsBatch == null) continue;
                ++count;
            }
            return count;
        }
    }

    private static final class SharedSubscriptionData {
        final ShareName name;
        final Topic topicFilter;
        final MqttSubscriptionOption option;

        private SharedSubscriptionData(ShareName name, Topic topicFilter, MqttSubscriptionOption option) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(topicFilter);
            Objects.requireNonNull(option);
            this.name = name;
            this.topicFilter = topicFilter;
            this.option = option;
        }

        static SharedSubscriptionData fromMqttSubscription(MqttTopicSubscription sub) {
            return new SharedSubscriptionData(new ShareName(SharedSubscriptionUtils.extractShareName(sub.topicName())), Topic.asTopic(SharedSubscriptionUtils.extractFilterFromShared(sub.topicName())), sub.option());
        }
    }

    static class ExpirableTopic
    implements Expirable {
        private final Topic topic;
        private Instant expireAt;

        public ExpirableTopic(Topic topic, Instant expireAt) {
            this.topic = topic;
            this.expireAt = expireAt;
        }

        @Override
        public Optional<Instant> expireAt() {
            return Optional.of(this.expireAt);
        }
    }

    static class RouteResult {
        private final String clientId;
        private final Status status;
        private CompletableFuture queuedFuture;

        public static RouteResult success(String clientId, CompletableFuture queuedFuture) {
            return new RouteResult(clientId, Status.SUCCESS, queuedFuture);
        }

        public static RouteResult failed(String clientId) {
            return RouteResult.failed(clientId, null);
        }

        public static RouteResult failed(String clientId, String error) {
            CompletableFuture failed = new CompletableFuture();
            failed.completeExceptionally(new Error(error));
            return new RouteResult(clientId, Status.FAIL, failed);
        }

        private RouteResult(String clientId, Status status, CompletableFuture queuedFuture) {
            this.clientId = clientId;
            this.status = status;
            this.queuedFuture = queuedFuture;
        }

        public CompletableFuture completableFuture() {
            if (this.status == Status.FAIL) {
                throw new IllegalArgumentException("Accessing completable future on a failed result");
            }
            return this.queuedFuture;
        }

        public boolean isSuccess() {
            return this.status == Status.SUCCESS;
        }

        public RouteResult ifFailed(Runnable action) {
            if (!this.isSuccess()) {
                action.run();
            }
            return this;
        }

        static enum Status {
            SUCCESS,
            FAIL;

        }
    }

    private static class FailedPublishCollection {
        private final ConcurrentMap<PacketId, Set<String>> packetsMap = new ConcurrentHashMap<PacketId, Set<String>>();

        private FailedPublishCollection() {
        }

        private void insert(String clientId, int messageID, String failedClientId) {
            PacketId packetId = new PacketId(clientId, messageID);
            this.packetsMap.computeIfAbsent(packetId, k -> new HashSet()).add(failedClientId);
        }

        public void remove(String clientId, int messageID, String targetClientId) {
            PacketId packetId = new PacketId(clientId, messageID);
            this.packetsMap.computeIfPresent(packetId, (key, clientsSet) -> {
                clientsSet.remove(targetClientId);
                if (clientsSet.isEmpty()) {
                    return null;
                }
                return clientsSet;
            });
        }

        private void removeAll(int messageID, String clientId, Collection<String> routings) {
            for (String targetClientId : routings) {
                this.remove(clientId, messageID, targetClientId);
            }
        }

        void cleanupForClient(String clientId) {
            this.packetsMap.keySet().stream().filter(packet -> packet.belongToClient(clientId)).forEach(this.packetsMap::remove);
        }

        void insertAll(int messageID, String clientId, Collection<String> routings) {
            for (String targetClientId : routings) {
                this.insert(clientId, messageID, targetClientId);
            }
        }

        Set<String> listFailed(String clientId, int messageID) {
            PacketId packetId = new PacketId(clientId, messageID);
            return this.packetsMap.getOrDefault(packetId, Collections.emptySet());
        }

        static class PacketId {
            private final String clientId;
            private final int idPacket;

            PacketId(String clientId, int idPacket) {
                this.clientId = clientId;
                this.idPacket = idPacket;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PacketId packetId = (PacketId)o;
                return this.idPacket == packetId.idPacket && Objects.equals(this.clientId, packetId.clientId);
            }

            public int hashCode() {
                return Objects.hash(this.clientId, this.idPacket);
            }

            public boolean belongToClient(String clientId) {
                return this.clientId.equals(clientId);
            }
        }
    }
}

