/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class ServiceUnavailableDecorator
implements HttpServerRequestHandler {
    private final HttpServerRequestHandler requestHandler;
    private final Resolver<HttpRequest, TimeValue> serviceAvailabilityResolver;
    private final AtomicBoolean serviceUnavailable;

    public ServiceUnavailableDecorator(HttpServerRequestHandler requestHandler, Resolver<HttpRequest, TimeValue> serviceAvailabilityResolver) {
        this.requestHandler = (HttpServerRequestHandler)Args.notNull((Object)requestHandler, (String)"Request handler");
        this.serviceAvailabilityResolver = (Resolver)Args.notNull(serviceAvailabilityResolver, (String)"Service availability resolver");
        this.serviceUnavailable = new AtomicBoolean();
    }

    public void handle(ClassicHttpRequest request, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        TimeValue retryAfter = (TimeValue)this.serviceAvailabilityResolver.resolve((Object)request);
        this.serviceUnavailable.set(TimeValue.isPositive((TimeValue)retryAfter));
        if (this.serviceUnavailable.get()) {
            BasicClassicHttpResponse response = new BasicClassicHttpResponse(503);
            response.addHeader("Retry-After", (Object)Long.toString(retryAfter.toSeconds()));
            ProtocolVersion version = request.getVersion();
            if (version != null && version.compareToVersion((ProtocolVersion)HttpVersion.HTTP_2) < 0) {
                response.addHeader("Connection", (Object)"Close");
            }
            responseTrigger.submitResponse((ClassicHttpResponse)response);
        } else {
            this.requestHandler.handle(request, responseTrigger, context);
        }
    }
}

