/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;

public final class InflatingGzipDataConsumer
implements AsyncDataConsumer {
    private static final int OUT = 8192;
    private final AsyncDataConsumer downstream;
    private final Inflater inflater = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private final byte[] out = new byte[8192];
    private final ByteArrayOutputStream headerBuf = new ByteArrayOutputStream(18);
    private boolean headerDone = false;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public InflatingGzipDataConsumer(AsyncDataConsumer downstream) {
        this.downstream = downstream;
    }

    public void updateCapacity(CapacityChannel c) throws IOException {
        this.downstream.updateCapacity(c);
    }

    public void consume(ByteBuffer src) throws IOException {
        if (this.closed.get()) {
            return;
        }
        if (!this.headerDone) {
            while (src.hasRemaining() && this.headerBuf.size() < 10) {
                this.headerBuf.write(src.get());
            }
            if (this.headerBuf.size() < 10) {
                return;
            }
            byte[] hdr = this.headerBuf.toByteArray();
            if (hdr[0] != 31 || hdr[1] != -117 || hdr[2] != 8) {
                throw new IOException("Malformed GZIP header");
            }
            int flg = hdr[3] & 0xFF;
            int need = 10;
            if ((flg & 4) != 0) {
                need += 2;
            }
            if ((flg & 8) != 0) {
                need = Integer.MAX_VALUE;
            }
            if ((flg & 0x10) != 0) {
                need = Integer.MAX_VALUE;
            }
            if ((flg & 2) != 0) {
                need += 2;
            }
            while (src.hasRemaining() && this.headerBuf.size() < need) {
                this.headerBuf.write(src.get());
                if (need != Integer.MAX_VALUE || this.headerBuf.toByteArray()[this.headerBuf.size() - 1] != 0) continue;
                if (flg == 8 || flg == 16) {
                    flg ^= flg & 0x18;
                }
                if ((flg & 0x18) != 0) continue;
                need = this.headerBuf.size();
            }
            if (this.headerBuf.size() < need) {
                return;
            }
            this.headerDone = true;
        }
        byte[] in = new byte[src.remaining()];
        src.get(in);
        this.inflater.setInput(in);
        try {
            int n;
            while ((n = this.inflater.inflate(this.out)) > 0) {
                this.crc.update(this.out, 0, n);
                this.downstream.consume(ByteBuffer.wrap(this.out, 0, n));
            }
        }
        catch (DataFormatException ex) {
            throw new IOException("Corrupt GZIP stream", ex);
        }
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.inflater.end();
            this.downstream.streamEnd(trailers);
        }
    }

    public void releaseResources() {
        this.inflater.end();
        this.downstream.releaseResources();
    }
}

