/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.Tokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestTokenizer {
    private Tokenizer parser;

    TestTokenizer() {
    }

    @BeforeEach
    void setUp() {
        this.parser = new Tokenizer();
    }

    private static CharArrayBuffer createBuffer(String value) {
        if (value == null) {
            return null;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return buffer;
    }

    @Test
    void testBasicTokenParsing() {
        String s = "   raw: \" some stuff \"";
        CharArrayBuffer raw = TestTokenizer.createBuffer("   raw: \" some stuff \"");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "   raw: \" some stuff \"".length());
        this.parser.skipWhiteSpace((CharSequence)raw, cursor);
        Assertions.assertFalse((boolean)cursor.atEnd());
        Assertions.assertEquals((int)3, (int)cursor.getPos());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent((CharSequence)raw, cursor, Tokenizer.delimiters((char)':'), strbuf1);
        Assertions.assertFalse((boolean)cursor.atEnd());
        Assertions.assertEquals((int)6, (int)cursor.getPos());
        Assertions.assertEquals((Object)"raw", (Object)strbuf1.toString());
        Assertions.assertEquals((char)':', (char)raw.charAt(cursor.getPos()));
        cursor.updatePos(cursor.getPos() + 1);
        this.parser.skipWhiteSpace((CharSequence)raw, cursor);
        Assertions.assertFalse((boolean)cursor.atEnd());
        Assertions.assertEquals((int)8, (int)cursor.getPos());
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent((CharSequence)raw, cursor, strbuf2);
        Assertions.assertTrue((boolean)cursor.atEnd());
        Assertions.assertEquals((Object)" some stuff ", (Object)strbuf2.toString());
        this.parser.copyQuotedContent((CharSequence)raw, cursor, strbuf2);
        Assertions.assertTrue((boolean)cursor.atEnd());
        this.parser.skipWhiteSpace((CharSequence)raw, cursor);
        Assertions.assertTrue((boolean)cursor.atEnd());
    }

    @Test
    void testTokenParsingWithQuotedPairs() {
        String s = "raw: \"\\\"some\\stuff\\\\\"";
        CharArrayBuffer raw = TestTokenizer.createBuffer("raw: \"\\\"some\\stuff\\\\\"");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "raw: \"\\\"some\\stuff\\\\\"".length());
        this.parser.skipWhiteSpace((CharSequence)raw, cursor);
        Assertions.assertFalse((boolean)cursor.atEnd());
        Assertions.assertEquals((int)0, (int)cursor.getPos());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent((CharSequence)raw, cursor, Tokenizer.delimiters((char)':'), strbuf1);
        Assertions.assertFalse((boolean)cursor.atEnd());
        Assertions.assertEquals((Object)"raw", (Object)strbuf1.toString());
        Assertions.assertEquals((char)':', (char)raw.charAt(cursor.getPos()));
        cursor.updatePos(cursor.getPos() + 1);
        this.parser.skipWhiteSpace((CharSequence)raw, cursor);
        Assertions.assertFalse((boolean)cursor.atEnd());
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent((CharSequence)raw, cursor, strbuf2);
        Assertions.assertTrue((boolean)cursor.atEnd());
        Assertions.assertEquals((Object)"\"some\\stuff\\", (Object)strbuf2.toString());
    }

    @Test
    void testTokenParsingIncompleteQuote() {
        String s = "\"stuff and more stuff  ";
        CharArrayBuffer raw = TestTokenizer.createBuffer("\"stuff and more stuff  ");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "\"stuff and more stuff  ".length());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyQuotedContent((CharSequence)raw, cursor, strbuf1);
        Assertions.assertEquals((Object)"stuff and more stuff  ", (Object)strbuf1.toString());
    }

    @Test
    void testTokenParsingTokensWithUnquotedBlanks() {
        String s = "  stuff and   \tsome\tmore  stuff  ;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("  stuff and   \tsome\tmore  stuff  ;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "  stuff and   \tsome\tmore  stuff  ;".length());
        String result = this.parser.parseToken((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuff and some more stuff", (Object)result);
    }

    @Test
    void testTokenParsingMixedValuesAndQuotedValues() {
        String s = "  stuff and    \" some more \"   \"stuff  ;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("  stuff and    \" some more \"   \"stuff  ;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "  stuff and    \" some more \"   \"stuff  ;".length());
        String result = this.parser.parseValue((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuff and  some more  stuff  ;", (Object)result);
    }

    @Test
    void testTokenParsingMixedValuesAndQuotedValues2() {
        String s = "stuff\"more\"stuff;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("stuff\"more\"stuff;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "stuff\"more\"stuff;".length());
        String result = this.parser.parseValue((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuffmorestuff", (Object)result);
    }

    @Test
    void testTokenParsingEscapedQuotes() {
        String s = "stuff\"\\\"more\\\"\"stuff;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("stuff\"\\\"more\\\"\"stuff;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "stuff\"\\\"more\\\"\"stuff;".length());
        String result = this.parser.parseValue((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuff\"more\"stuff", (Object)result);
    }

    @Test
    void testTokenParsingEscapedDelimiter() {
        String s = "stuff\"\\\"more\\\";\"stuff;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("stuff\"\\\"more\\\";\"stuff;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "stuff\"\\\"more\\\";\"stuff;".length());
        String result = this.parser.parseValue((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuff\"more\";stuff", (Object)result);
    }

    @Test
    void testTokenParsingEscapedSlash() {
        String s = "stuff\"\\\"more\\\";\\\\\"stuff;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("stuff\"\\\"more\\\";\\\\\"stuff;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "stuff\"\\\"more\\\";\\\\\"stuff;".length());
        String result = this.parser.parseValue((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuff\"more\";\\stuff", (Object)result);
    }

    @Test
    void testTokenParsingSlashOutsideQuotes() {
        String s = "stuff\\; more stuff;";
        CharArrayBuffer raw = TestTokenizer.createBuffer("stuff\\; more stuff;");
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, "stuff\\; more stuff;".length());
        String result = this.parser.parseValue((CharSequence)raw, cursor, Tokenizer.delimiters((char)';'));
        Assertions.assertEquals((Object)"stuff\\", (Object)result);
    }
}

