/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

final class BinaryDataSerializer
extends JsonSerializer<BinaryData> {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDataSerializer.class);

    BinaryDataSerializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BinaryData.class, (JsonSerializer)new BinaryDataSerializer());
        return module;
    }

    public void serialize(BinaryData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            return;
        }
        BinaryDataContent content = BinaryDataHelper.getContent(value);
        switch (content.getContentType()) {
            case BINARY: {
                gen.writeBinary(content.toBytes());
                break;
            }
            case OBJECT: {
                gen.writeRawValue(content.toString());
                break;
            }
            case TEXT: {
                gen.writeString(content.toString());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Unsupported BinaryData content type: " + content.getClass().getName()));
            }
        }
    }
}

