/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.implementation.accesshelpers.BlobItemPropertiesConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobItemPropertiesInternal;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.RehydratePriority;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Properties")
public final class BlobItemProperties {
    @JsonUnwrapped
    private final BlobItemPropertiesInternal internalProperties;
    @JsonIgnore
    private BlobImmutabilityPolicy convertedImmutabilityPolicy;

    private BlobItemProperties(BlobItemPropertiesInternal internalProperties) {
        this.internalProperties = internalProperties;
    }

    public BlobItemProperties() {
        this.internalProperties = new BlobItemPropertiesInternal();
    }

    public OffsetDateTime getCreationTime() {
        return this.internalProperties.getCreationTime();
    }

    public BlobItemProperties setCreationTime(OffsetDateTime creationTime) {
        this.internalProperties.setCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime getLastModified() {
        return this.internalProperties.getLastModified();
    }

    public BlobItemProperties setLastModified(OffsetDateTime lastModified) {
        this.internalProperties.setLastModified(lastModified);
        return this;
    }

    public String getETag() {
        return this.internalProperties.getETag();
    }

    public BlobItemProperties setETag(String eTag) {
        this.internalProperties.setETag(eTag);
        return this;
    }

    public Long getContentLength() {
        return this.internalProperties.getContentLength();
    }

    public BlobItemProperties setContentLength(Long contentLength) {
        this.internalProperties.setContentLength(contentLength);
        return this;
    }

    public String getContentType() {
        return this.internalProperties.getContentType();
    }

    public BlobItemProperties setContentType(String contentType) {
        this.internalProperties.setContentType(contentType);
        return this;
    }

    public String getContentEncoding() {
        return this.internalProperties.getContentEncoding();
    }

    public BlobItemProperties setContentEncoding(String contentEncoding) {
        this.internalProperties.setContentEncoding(contentEncoding);
        return this;
    }

    public String getContentLanguage() {
        return this.internalProperties.getContentLanguage();
    }

    public BlobItemProperties setContentLanguage(String contentLanguage) {
        this.internalProperties.setContentLanguage(contentLanguage);
        return this;
    }

    public byte[] getContentMd5() {
        return this.internalProperties.getContentMd5();
    }

    public BlobItemProperties setContentMd5(byte[] contentMd5) {
        this.internalProperties.setContentMd5(contentMd5);
        return this;
    }

    public String getContentDisposition() {
        return this.internalProperties.getContentDisposition();
    }

    public BlobItemProperties setContentDisposition(String contentDisposition) {
        this.internalProperties.setContentDisposition(contentDisposition);
        return this;
    }

    public String getCacheControl() {
        return this.internalProperties.getCacheControl();
    }

    public BlobItemProperties setCacheControl(String cacheControl) {
        this.internalProperties.setCacheControl(cacheControl);
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.internalProperties.getBlobSequenceNumber();
    }

    public BlobItemProperties setBlobSequenceNumber(Long blobSequenceNumber) {
        this.internalProperties.setBlobSequenceNumber(blobSequenceNumber);
        return this;
    }

    public BlobType getBlobType() {
        return this.internalProperties.getBlobType();
    }

    public BlobItemProperties setBlobType(BlobType blobType) {
        this.internalProperties.setBlobType(blobType);
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.internalProperties.getLeaseStatus();
    }

    public BlobItemProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.internalProperties.setLeaseStatus(leaseStatus);
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.internalProperties.getLeaseState();
    }

    public BlobItemProperties setLeaseState(LeaseStateType leaseState) {
        this.internalProperties.setLeaseState(leaseState);
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.internalProperties.getLeaseDuration();
    }

    public BlobItemProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.internalProperties.setLeaseDuration(leaseDuration);
        return this;
    }

    public String getCopyId() {
        return this.internalProperties.getCopyId();
    }

    public BlobItemProperties setCopyId(String copyId) {
        this.internalProperties.setCopyId(copyId);
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.internalProperties.getCopyStatus();
    }

    public BlobItemProperties setCopyStatus(CopyStatusType copyStatus) {
        this.internalProperties.setCopyStatus(copyStatus);
        return this;
    }

    public String getCopySource() {
        return this.internalProperties.getCopySource();
    }

    public BlobItemProperties setCopySource(String copySource) {
        this.internalProperties.setCopySource(copySource);
        return this;
    }

    public String getCopyProgress() {
        return this.internalProperties.getCopyProgress();
    }

    public BlobItemProperties setCopyProgress(String copyProgress) {
        this.internalProperties.setCopyProgress(copyProgress);
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.internalProperties.getCopyCompletionTime();
    }

    public BlobItemProperties setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.internalProperties.setCopyCompletionTime(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.internalProperties.getCopyStatusDescription();
    }

    public BlobItemProperties setCopyStatusDescription(String copyStatusDescription) {
        this.internalProperties.setCopyStatusDescription(copyStatusDescription);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.internalProperties.isServerEncrypted();
    }

    public BlobItemProperties setServerEncrypted(Boolean serverEncrypted) {
        this.internalProperties.setServerEncrypted(serverEncrypted);
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.internalProperties.isIncrementalCopy();
    }

    public BlobItemProperties setIncrementalCopy(Boolean incrementalCopy) {
        this.internalProperties.setIncrementalCopy(incrementalCopy);
        return this;
    }

    public String getDestinationSnapshot() {
        return this.internalProperties.getDestinationSnapshot();
    }

    public BlobItemProperties setDestinationSnapshot(String destinationSnapshot) {
        this.internalProperties.setDestinationSnapshot(destinationSnapshot);
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        return this.internalProperties.getDeletedTime();
    }

    public BlobItemProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.internalProperties.setDeletedTime(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.internalProperties.getRemainingRetentionDays();
    }

    public BlobItemProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.internalProperties.setRemainingRetentionDays(remainingRetentionDays);
        return this;
    }

    public AccessTier getAccessTier() {
        return this.internalProperties.getAccessTier();
    }

    public BlobItemProperties setAccessTier(AccessTier accessTier) {
        this.internalProperties.setAccessTier(accessTier);
        return this;
    }

    public Boolean isAccessTierInferred() {
        return this.internalProperties.isAccessTierInferred();
    }

    public BlobItemProperties setAccessTierInferred(Boolean accessTierInferred) {
        this.internalProperties.setAccessTierInferred(accessTierInferred);
        return this;
    }

    public ArchiveStatus getArchiveStatus() {
        return this.internalProperties.getArchiveStatus();
    }

    public BlobItemProperties setArchiveStatus(ArchiveStatus archiveStatus) {
        this.internalProperties.setArchiveStatus(archiveStatus);
        return this;
    }

    public String getCustomerProvidedKeySha256() {
        return this.internalProperties.getCustomerProvidedKeySha256();
    }

    public BlobItemProperties setCustomerProvidedKeySha256(String customerProvidedKeySha256) {
        this.internalProperties.setCustomerProvidedKeySha256(customerProvidedKeySha256);
        return this;
    }

    public String getEncryptionScope() {
        return this.internalProperties.getEncryptionScope();
    }

    public BlobItemProperties setEncryptionScope(String encryptionScope) {
        this.internalProperties.setEncryptionScope(encryptionScope);
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        return this.internalProperties.getAccessTierChangeTime();
    }

    public BlobItemProperties setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.internalProperties.setAccessTierChangeTime(accessTierChangeTime);
        return this;
    }

    public Integer getTagCount() {
        return this.internalProperties.getTagCount();
    }

    public BlobItemProperties setTagCount(Integer tagCount) {
        this.internalProperties.setTagCount(tagCount);
        return this;
    }

    public RehydratePriority getRehydratePriority() {
        return this.internalProperties.getRehydratePriority();
    }

    public BlobItemProperties setRehydratePriority(RehydratePriority rehydratePriority) {
        this.internalProperties.setRehydratePriority(rehydratePriority);
        return this;
    }

    public Boolean isSealed() {
        return this.internalProperties.isSealed();
    }

    public BlobItemProperties setSealed(Boolean sealed) {
        this.internalProperties.setIsSealed(sealed);
        return this;
    }

    public OffsetDateTime getLastAccessedTime() {
        return this.internalProperties.getLastAccessedOn();
    }

    public BlobItemProperties setLastAccessedTime(OffsetDateTime lastAccessedTime) {
        this.internalProperties.setLastAccessedOn(lastAccessedTime);
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.internalProperties.getExpiresOn();
    }

    public BlobItemProperties setExpiryTime(OffsetDateTime expiryTime) {
        this.internalProperties.setExpiresOn(expiryTime);
        return this;
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        if (this.convertedImmutabilityPolicy == null) {
            this.convertedImmutabilityPolicy = new BlobImmutabilityPolicy().setExpiryTime(this.internalProperties.getImmutabilityPolicyExpiresOn()).setPolicyMode(this.internalProperties.getImmutabilityPolicyMode());
        }
        return this.convertedImmutabilityPolicy;
    }

    public BlobItemProperties setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        this.convertedImmutabilityPolicy = immutabilityPolicy;
        if (immutabilityPolicy != null) {
            this.internalProperties.setImmutabilityPolicyExpiresOn(immutabilityPolicy.getExpiryTime());
            this.internalProperties.setImmutabilityPolicyMode(immutabilityPolicy.getPolicyMode());
        } else {
            this.internalProperties.setImmutabilityPolicyExpiresOn(null);
            this.internalProperties.setImmutabilityPolicyMode(null);
        }
        return this;
    }

    public Boolean hasLegalHold() {
        return this.internalProperties.isLegalHold();
    }

    public BlobItemProperties setHasLegalHold(Boolean hasLegalHold) {
        this.internalProperties.setLegalHold(hasLegalHold);
        return this;
    }

    static {
        BlobItemPropertiesConstructorProxy.setAccessor(new BlobItemPropertiesConstructorProxy.BlobItemPropertiesConstructorAccessor(){

            @Override
            public BlobItemProperties create(BlobItemPropertiesInternal internalProperties) {
                return new BlobItemProperties(internalProperties);
            }

            @Override
            public BlobItemPropertiesInternal getInternalProperties(BlobItemProperties properties) {
                return properties.internalProperties;
            }
        });
    }
}

