/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.watcher;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.openhft.chronicle.core.watcher.JMXFileManager;
import net.openhft.chronicle.core.watcher.PlainFileManagerMBean;

class PlainFileManager
extends JMXFileManager
implements PlainFileManagerMBean {
    private final Path path;

    public PlainFileManager(String base, String relative, Path path) {
        super(base, relative);
        this.path = path;
    }

    @Override
    protected String type() {
        return "files";
    }

    @Override
    public String getFileSize() {
        try {
            long size = Files.size(this.path);
            if (size < 2048L) {
                return size + " B";
            }
            if (size < 0x200000L) {
                return (double)(size * 10L >> 10) / 10.0 + " KiB";
            }
            return (double)(size * 10L >> 20) / 10.0 + " MiB";
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    @Override
    public String getContentType() {
        try {
            return Files.probeContentType(this.path);
        }
        catch (IOException e) {
            return "Unknown";
        }
    }
}

