/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.status;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnWorkerStatusGrpc;
import org.apache.beam.runners.fnexecution.status.WorkerStatusClient;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.HeaderAccessor;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamWorkerStatusGrpcService
extends BeamFnWorkerStatusGrpc.BeamFnWorkerStatusImplBase
implements FnService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamWorkerStatusGrpcService.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_EXCEPTION_RESPONSE = "Error: exception encountered getting status from SDK harness";
    private final @UnknownKeyFor @NonNull @Initialized HeaderAccessor headerAccessor;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized WorkerStatusClient>> connectedClient = Collections.synchronizedMap(new HashMap());
    private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean isClosed = new AtomicBoolean();

    private BeamWorkerStatusGrpcService(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized HeaderAccessor headerAccessor) {
        this.headerAccessor = headerAccessor;
        LOG.info("Launched Beam Fn Status service at {}", (Object)apiServiceDescriptor);
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamWorkerStatusGrpcService create(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized HeaderAccessor headerAccessor) {
        return new BeamWorkerStatusGrpcService(apiServiceDescriptor, headerAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        Map<String, CompletableFuture<WorkerStatusClient>> map = this.connectedClient;
        synchronized (map) {
            for (CompletableFuture<WorkerStatusClient> clientFuture : this.connectedClient.values()) {
                if (!clientFuture.isDone()) continue;
                clientFuture.get().close();
            }
            this.connectedClient.clear();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.WorkerStatusResponse> workerStatus(@UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.WorkerStatusRequest> requestObserver) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("BeamWorkerStatusGrpcService already closed.");
        }
        String workerId = this.headerAccessor.getSdkWorkerId();
        LOG.info("Beam Fn Status client connected with id {}", (Object)workerId);
        WorkerStatusClient fnApiStatusClient = WorkerStatusClient.forRequestObserver(workerId, requestObserver);
        this.connectedClient.compute(workerId, (k, existingClientFuture) -> {
            if (existingClientFuture != null) {
                try {
                    if (!existingClientFuture.isDone()) {
                        existingClientFuture.complete(fnApiStatusClient);
                        return existingClientFuture;
                    }
                    LOG.info("SDK Worker {} was connected to status server previously, disconnecting old client", (Object)workerId);
                    ((WorkerStatusClient)existingClientFuture.get()).close();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    LOG.warn("Error closing worker status client", (Throwable)e);
                }
            }
            return CompletableFuture.completedFuture(fnApiStatusClient);
        });
        return fnApiStatusClient.getResponseObserver();
    }

    public @UnknownKeyFor @NonNull @Initialized String getSingleWorkerStatus(@UnknownKeyFor @NonNull @Initialized String workerId, @UnknownKeyFor @NonNull @Initialized long timeout, @UnknownKeyFor @NonNull @Initialized TimeUnit timeUnit) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("BeamWorkerStatusGrpcService already closed.");
        }
        try {
            return this.getWorkerStatus(workerId).get(timeout, timeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return this.handleAndReturnExceptionResponse(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getAllWorkerStatuses(@UnknownKeyFor @NonNull @Initialized long timeout, @UnknownKeyFor @NonNull @Initialized TimeUnit timeUnit) {
        ImmutableSet connectedClientIdsCopy;
        if (this.isClosed.get()) {
            throw new IllegalStateException("BeamWorkerStatusGrpcService already closed.");
        }
        ConcurrentSkipListMap<String, String> allStatuses = new ConcurrentSkipListMap<String, String>(Comparator.naturalOrder());
        Map<String, CompletableFuture<WorkerStatusClient>> map = this.connectedClient;
        synchronized (map) {
            connectedClientIdsCopy = ImmutableSet.copyOf(this.connectedClient.keySet());
        }
        connectedClientIdsCopy.parallelStream().forEach(workerId -> allStatuses.put((String)workerId, this.getSingleWorkerStatus((String)workerId, timeout, timeUnit)));
        return allStatuses;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized String> getWorkerStatus(@UnknownKeyFor @NonNull @Initialized String workerId) {
        try {
            CompletableFuture<WorkerStatusClient> statusClient = this.getStatusClient(workerId);
            if (!statusClient.isDone()) {
                return CompletableFuture.completedFuture("Error: Not connected.");
            }
            CompletableFuture<BeamFnApi.WorkerStatusResponse> future = statusClient.get().getWorkerStatus();
            return future.thenApply(this::getStatusErrorOrInfo);
        }
        catch (InterruptedException | ExecutionException e) {
            return CompletableFuture.completedFuture(this.handleAndReturnExceptionResponse(e));
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized WorkerStatusClient> getStatusClient(@UnknownKeyFor @NonNull @Initialized String workerId) {
        return this.connectedClient.computeIfAbsent(workerId, k -> new CompletableFuture());
    }

    private @UnknownKeyFor @NonNull @Initialized String getStatusErrorOrInfo(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.WorkerStatusResponse response) {
        return !Strings.isNullOrEmpty((String)response.getError()) ? response.getError() : response.getStatusInfo();
    }

    private @UnknownKeyFor @NonNull @Initialized String handleAndReturnExceptionResponse(@UnknownKeyFor @NonNull @Initialized Exception e) {
        LOG.warn(DEFAULT_EXCEPTION_RESPONSE, (Throwable)e);
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        StringBuilder response = new StringBuilder();
        response.append(DEFAULT_EXCEPTION_RESPONSE).append(": ").append(e.getClass().getCanonicalName());
        if (e.getMessage() != null) {
            response.append(": ").append(e.getMessage());
        }
        return response.toString();
    }
}

